package org.arquillian.container.chameleon.deployment.maven;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface MavenBuild {

    /**
     * Goal to execute for building archive.
     * @return List of goals
     */
    String[] goals() default "package";

    /**
     * Maven version to use
     * @return X.Y.Z of Maven version to use to build the project
     */
    String version() default "3.5.0";

    /**
     * Enable profiles to be run
     * @return List of profiles used.
     */
    String[] profiles() default {};

    /**
     * Location of pom.xml file used to run the build
     * @return pom.xml file relative to current module. By default current pom.xml is used.
     */
    String pom() default "pom.xml";

    /**
     * In case of multiple module project, archive generated by set pom.xml is deployed. If you want to use another one,
     * you can set it which module generated the deployable archive.
     * @return
     */
    String module() default "";

    /**
     * Local Repository Directory.
     * @return Configures local repository directory.
     */
    String localRepositoryDirectory() default "";

    /**
     * Sets Maven in offline mode.
     * @return
     */
    boolean offline() default false;

    /**
     * Sets Maven options
     * @return
     */
    String mvnOpts() default "";

    /**
     * Sets properties for building the project (equivalent to -D)
     * @return An array with properties where first element is the name and the second is the value.
     */
    String[] properties() default {};

    /**
     * In case of disabling quiet mode, Maven output is printed to console
     * @return 
     */
    boolean quiet() default true;

}
