/**
 * JBoss, Home of Professional Open Source
 * Copyright 2014, Red Hat, Inc. and/or its affiliates, and individual
 * contributors by the @authors tag. See the copyright.txt in the
 * distribution for a full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.arquillian.droidium.container.api;

import java.util.ArrayList;
import java.util.List;

/**
 * Metadata related to {@link AndroidDevice} in order to bound it to deployment method names and container qualifier.
 *
 * @author <a href="smikloso@redhat.com">Stefan Miklosovic</a>
 *
 */
public final class AndroidDeviceMetadata {

    private List<String> deploymentNames;

    private String containerQualifier;

    public AndroidDeviceMetadata() {
        deploymentNames = new ArrayList<String>();
    }

    public void setContainerQualifier(String containerQualifier) {
        this.containerQualifier = containerQualifier;
    }

    public String getContainerQualifier() {
        return containerQualifier;
    }

    public void addDeploymentName(String deploymentName) {
        deploymentNames.add(deploymentName);
    }

    public List<String> getDeploymentNames() {
        return deploymentNames;
    }

    public boolean operatesOnDeployment(String deploymentName) {
        return deploymentNames.contains(deploymentName);
    }
}
