/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.log.LogLevel;
import org.arquillian.droidium.container.log.LogType;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class AndroidContainerConfiguration
implements ContainerConfiguration {
    private String fileSeparator = System.getProperty("file.separator");
    private static final Logger logger = Logger.getLogger(AndroidContainerConfiguration.class.getName());
    private boolean forceNewBridge = true;
    private String serialId;
    private String avdName;
    private String generatedAvdPath = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator");
    private String emulatorOptions;
    private String sdSize = "128M";
    private String sdCard;
    private String sdCardLabel;
    private boolean generateSDCard;
    private String abi;
    private long emulatorBootupTimeoutInSeconds = 120L;
    private long emulatorShutdownTimeoutInSeconds = 60L;
    private String home = System.getenv("ANDROID_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private boolean avdGenerated;
    private String consolePort;
    private String adbPort;
    private int droneHostPort = 14444;
    private int droneGuestPort = 8080;
    private String logLevel = LogLevel.DEFAULT;
    private String logType = LogType.DEFAULT;
    private String logFilePath = "target/logcat.log";
    private String logPackageWhitelist;
    private String logPackageBlacklist;
    private String keystore = System.getProperty("user.home") + this.fileSeparator + ".android" + this.fileSeparator + "debug.keystore";
    private String storepass = "android";
    private String keypass = "android";
    private String alias = "androiddebugkey";
    private String sigalg = "SHA1withRSA";
    private String keyalg = "RSA";
    private boolean removeTmpDir = true;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private boolean logSerialId;
    private String apiLevel = "10";

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public void setAvdName(String avdName) {
        this.avdName = avdName;
    }

    public void setGeneratedAvdPath(String generatedAvdPath) {
        this.generatedAvdPath = generatedAvdPath;
    }

    public String getGeneratedAvdPath() {
        return this.generatedAvdPath;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getEmulatorOptions() {
        return this.emulatorOptions;
    }

    public void setEmulatorOptions(String emulatorOptions) {
        this.emulatorOptions = emulatorOptions;
    }

    public boolean isForceNewBridge() {
        return this.forceNewBridge;
    }

    public void setForceNewBridge(boolean force) {
        this.forceNewBridge = force;
    }

    public long getEmulatorBootupTimeoutInSeconds() {
        return this.emulatorBootupTimeoutInSeconds;
    }

    public void setEmulatorBootupTimeoutInSeconds(long emulatorBootupTimeoutInSeconds) {
        this.emulatorBootupTimeoutInSeconds = emulatorBootupTimeoutInSeconds;
    }

    public String getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(String apiLevel) {
        this.apiLevel = apiLevel;
    }

    public String getSdSize() {
        return this.sdSize;
    }

    public void setSdSize(String sdSize) {
        this.sdSize = sdSize;
    }

    public String getSdCard() {
        return this.sdCard;
    }

    public String getSdCardLabel() {
        return this.sdCardLabel;
    }

    public void setSdCardLabel(String sdCardLabel) {
        this.sdCardLabel = sdCardLabel;
    }

    public boolean getGenerateSDCard() {
        return this.generateSDCard;
    }

    public void setGenerateSDCard(boolean generate) {
        this.generateSDCard = generate;
    }

    public void setSdCard(String sdCard) {
        this.sdCard = sdCard;
    }

    public long getEmulatorShutdownTimeoutInSeconds() {
        return this.emulatorShutdownTimeoutInSeconds;
    }

    public void setEmulatorShutdownTimeoutInSeconds(long emulatorShutdownTimeoutInSeconds) {
        this.emulatorShutdownTimeoutInSeconds = emulatorShutdownTimeoutInSeconds;
    }

    public String getAbi() {
        return this.abi;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public boolean isAVDGenerated() {
        return this.avdGenerated;
    }

    public void setAvdGenerated(boolean generated) {
        this.avdGenerated = generated;
    }

    public boolean getAvdGenerated() {
        return this.avdGenerated;
    }

    public String getConsolePort() {
        return this.consolePort;
    }

    public void setConsolePort(String consolePort) {
        this.consolePort = consolePort;
    }

    public String getAdbPort() {
        return this.adbPort;
    }

    public void setAdbPort(String adbPort) {
        this.adbPort = adbPort;
    }

    public int getDroneHostPort() {
        return this.droneHostPort;
    }

    public int getDroneGuestPort() {
        return this.droneGuestPort;
    }

    public void setDroneHostPort(int droneHostPort) {
        this.droneHostPort = droneHostPort;
    }

    public void setDroneGuestPort(int droneGuestPort) {
        this.droneGuestPort = droneGuestPort;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getLogPackageWhitelist() {
        return this.logPackageWhitelist;
    }

    public void setLogPackageWhitelist(String logPackageWhitelist) {
        this.logPackageWhitelist = logPackageWhitelist;
    }

    public String getLogPackageBlacklist() {
        return this.logPackageBlacklist;
    }

    public void setLogPackageBlacklist(String logPackageBlacklist) {
        this.logPackageBlacklist = logPackageBlacklist;
    }

    public boolean isLogFilteringEnabled() {
        return this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") || this.logPackageBlacklist != null && !this.logPackageBlacklist.equals("");
    }

    public boolean isLogSerialId() {
        return this.logSerialId;
    }

    public void setLogSerialId(boolean logSerialId) {
        this.logSerialId = logSerialId;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public String getKeyalg() {
        return this.keyalg;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public boolean getRemoveTmpDir() {
        return this.removeTmpDir;
    }

    public void setRemoveTmpDir(boolean removeTmpDir) {
        this.removeTmpDir = removeTmpDir;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void validate() throws AndroidContainerConfigurationException {
        Validate.isReadableDirectory(this.home, "You must provide Android SDK home directory. The value you've provided is not valid (" + (this.home == null ? "" : this.home) + "). You can either set it via an environment variable ANDROID_HOME or via" + " a property called \"home\" in Arquillian configuration.");
        if (this.avdName != null && this.serialId != null) {
            logger.warning("Both \"avdName\" and \"serialId\" properties are defined, the device specified by \"serialId\" will get priority if connected.");
        }
        if (this.avdName == null && this.serialId == null && this.consolePort == null) {
            logger.severe("All \"avdName\", \"serialId\" and \"consolePort\" are not defined.");
            throw new AndroidContainerConfigurationException("All \"avdName\", \"serialId\" and \"consolePort\" are not defined.");
        }
        if (this.generatedAvdPath != null) {
            File f;
            Validate.notNullOrEmpty(this.generatedAvdPath, "Directory you specified to store AVD to is empty string or null.");
            if (!this.generatedAvdPath.endsWith(System.getProperty("file.separator"))) {
                this.generatedAvdPath = this.generatedAvdPath + System.getProperty("file.separator");
            }
            if (!(f = new File(this.generatedAvdPath)).exists()) {
                try {
                    if (!f.mkdirs()) {
                        throw new AndroidContainerConfigurationException("Unable to create directory where AVD will be stored.");
                    }
                }
                catch (Exception e) {
                    throw new AndroidContainerConfigurationException("Unable to create directory where AVD will be stored (" + this.generatedAvdPath + "). Check that you have permission to create directory you specified.");
                }
            }
            Validate.isReadableDirectory(new File(this.generatedAvdPath), "Directory you specified as place where newly generated AVD will be placed does not exist (" + this.generatedAvdPath + ").");
            Validate.isWritable(new File(this.generatedAvdPath), "Path you want to store generated AVD is not writable!");
        }
        if (this.consolePort != null) {
            Validate.isConsolePortValid(this.consolePort);
        }
        if (this.adbPort != null) {
            Validate.isAdbPortValid(this.adbPort);
        }
        if (this.sdCard != null) {
            Validate.sdCardFileName(this.sdCard, "File name (or path) of SD card to use '" + this.sdCard + "' is not valid. Check it is under existing and writable directory does have '.img' suffix.");
        }
        if (this.sdCardLabel != null) {
            Validate.notNullOrEmpty(this.sdCardLabel, "SD card label can not be the empty string");
        }
        if (this.sdSize != null) {
            Validate.sdSize(this.sdSize, "Check you did specify your sdSize property in arquillian.xml properly.");
        }
        if (this.droneHostPort != 14444) {
            Validate.isPortValid(this.droneHostPort);
        }
        if (this.droneGuestPort != 8080) {
            Validate.isPortValid(this.droneGuestPort);
        }
        if (this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") && this.logPackageBlacklist == null) {
            this.logPackageBlacklist = "*";
            logger.warning("\"logPackageBlacklist\" isn't defined, but \"logPackageWhitelist\" is. Assuming \"*\" as a value for \"logPackageBlacklist\"!");
        }
        if (this.emulatorBootupTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator bootup timeout has to be bigger then 0.");
        }
        if (this.emulatorShutdownTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator shutdown timeout has to be bigger then 0.");
        }
        Validate.isReadableDirectory(this.getTmpDir(), "Temporary directory you chosed to use for Arquillian Droidium native plugin is not readable. Please be sure you entered a path you have read and write access to.");
        Validate.isWriteable(new File(this.getTmpDir()), "Temporary directory you chose to use for Arquillian Droidium native plugin is not writable. Please be sure you entered a path you have read and write access to.");
        try {
            Validate.isReadable(this.getKeystore(), "Key store for Android APKs is not readable. File does not exist or you have no read access to this file. In case it does not exist, Arquillian Droidium native plugin tries to create keystore you specified dynamically in the file " + this.getKeystore());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Validate.notNullOrEmpty(this.getAlias(), "You must provide valid alias for signing of APK files. You entered '" + this.getAlias() + "'.");
        Validate.notNullOrEmpty(this.getKeypass(), "You must provide valid keypass for signing of APK files. You entered '" + this.getKeypass() + "'.");
        Validate.notNullOrEmpty(this.getStorepass(), "You must provide valid storepass for signing of APK files. You entered '" + this.getStorepass() + "'.");
        Validate.notNullOrEmpty(this.getKeyalg(), "You must provide valid key algorithm for signing packages. You entered '" + this.getKeyalg() + "'.");
        Validate.notNullOrEmpty(this.getSigalg(), "You must provide valid key algoritm for signing packages. You entered '" + this.getSigalg() + "'.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\navdName\t\t\t:").append(this.avdName).append("\n");
        sb.append("generatedAvdPath\t:").append(this.generatedAvdPath).append("\n");
        sb.append("apiLevel\t\t:").append(this.apiLevel).append("\n");
        sb.append("serialId\t\t:").append(this.serialId).append("\n");
        sb.append("force\t\t\t:").append(this.forceNewBridge).append("\n");
        sb.append("sdCard\t\t\t:").append(this.sdCard).append("\n");
        sb.append("sdSize\t\t\t:").append(this.sdSize).append("\n");
        sb.append("generateSD\t\t:").append(this.generateSDCard).append("\n");
        sb.append("abi\t\t\t:").append(this.abi).append("\n");
        sb.append("emuBoot\t\t\t:").append(this.emulatorBootupTimeoutInSeconds).append("\n");
        sb.append("emuShut\t\t\t:").append(this.emulatorShutdownTimeoutInSeconds).append("\n");
        sb.append("emuOpts\t\t\t:").append(this.emulatorOptions).append("\n");
        sb.append("home\t\t\t:").append(this.home).append("\n");
        sb.append("consolePort\t\t:").append(this.consolePort).append("\n");
        sb.append("adbPort\t\t\t:").append(this.adbPort).append("\n");
        sb.append("logLevel\t\t:").append(this.logLevel).append("\n");
        sb.append("logType\t\t\t:").append(this.logType).append("\n");
        sb.append("logFilePath\t\t:").append(this.logFilePath).append("\n");
        sb.append("logPackageWhitelist\t:").append(this.logPackageWhitelist).append("\n");
        sb.append("logPackageBlacklist\t:").append(this.logPackageBlacklist).append("\n");
        sb.append("keystore\t\t:").append(this.keystore).append("\n");
        sb.append("keypass\t\t\t:").append(this.keypass).append("\n");
        sb.append("storepass\t\t:").append(this.storepass).append("\n");
        sb.append("alias\t\t\t:").append(this.alias).append("\n");
        sb.append("sigalg\t\t\t:").append(this.sigalg).append("\n");
        sb.append("keyalg\t\t\t:").append(this.keyalg).append("\n");
        sb.append("removeTmpDir\t\t:").append(this.removeTmpDir).append("\n");
        sb.append("tmpDir\t\t\t:").append(this.tmpDir).append("\n");
        return sb.toString();
    }
}

