/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.io.IOException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;

public class Validate {
    public static final long CONSOLE_PORT_MIN = 5554L;
    public static final long CONSOLE_PORT_MAX = 5584L;
    public static final long ADB_PORT_MIN = 5555L;
    public static final long ADB_PORT_MAX = 5585L;

    public static void notNull(Object object, String message) throws IllegalStateException, IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Exception message is a null object!");
        }
        if (object == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNulls(Object[] objects, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        Validate.notNull(objects, "Array to check the nullity of objects is a null object.");
        for (Object o : objects) {
            if (o != null) continue;
            throw new IllegalStateException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        if (string == null || string.trim().length() == 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void notAllNullsOrEmpty(String[] strings, String message) throws IllegalStateException {
        Validate.notNull(message, "Exception message is a null object!");
        Validate.notNull(strings, "Array to check the nullity of objects is null object!");
        for (String string : strings) {
            if (string == null || string.trim().length() == 0) continue;
            return;
        }
        throw new IllegalStateException(message);
    }

    public static boolean isReadable(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "File to check against readability is null object or empty.");
        File file = new File(path);
        return Validate.isReadable(file, message);
    }

    public static void isReadableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "Directory to check against readability is null object or empty string.");
        File file = new File(path);
        Validate.isReadableDirectory(file, message);
    }

    public static boolean isReadable(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, "File to check against readability is null object.");
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static void isReadableDirectory(File file, String message) throws IllegalArgumentException {
        Validate.notNull(file, "Directory to check against readability is null object.");
        if (!(file.exists() && file.isDirectory() && file.canRead() && file.canExecute())) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void sdSize(String sdSize, String message) throws AndroidContainerConfigurationException {
        long size;
        Validate.notNullOrEmpty(message, "Exception message is a null object!");
        Validate.notNullOrEmpty(sdSize, "Size of the Android SD card to check is null object or empty string");
        if (sdSize.trim().length() < 2 || !sdSize.matches("^[1-9]{1}[0-9]*[KGM]?$")) {
            throw new AndroidContainerConfigurationException(message);
        }
        String sizeString = null;
        String sizeUnit = null;
        if (sdSize.substring(sdSize.length() - 1).matches("[KGM]")) {
            sizeString = sdSize.substring(0, sdSize.length() - 1);
            sizeUnit = sdSize.substring(sdSize.length() - 1);
        } else {
            sizeString = sdSize;
        }
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse '" + sizeString + "' to number.");
        }
        if (sizeUnit == null) {
            if (size > 0xFFFFFFFE00L || size < 0x900000L) {
                throw new AndroidContainerConfigurationException("Minimum size is 9M. Maximum size is 1023G. The Android emulator cannot use smaller or bigger images.");
            }
            return;
        }
        if (size > 1023L && sizeUnit.equals("G") || size > 1048575L && sizeUnit.equals("M") || size > 0x3FFFFFFFL && sizeUnit.equals("K") || size < 9L && sizeUnit.equals("M") || size < 9126L && sizeUnit.equals("K")) {
            throw new AndroidContainerConfigurationException("Maximum size is 1099511627264 bytes, 1073741823K, 1048575M or 1023G. Minimum size is 9M. The Android emulator cannot use smaller images.");
        }
    }

    public static void isWritable(File file, String message) throws AndroidContainerConfigurationException {
        Validate.notNull(file, "File to check against writability is null object.");
        if (file.exists()) {
            if (file.canWrite()) {
                return;
            }
            throw new AndroidContainerConfigurationException(message);
        }
        try {
            file.createNewFile();
            file.delete();
        }
        catch (IOException e) {
            throw new AndroidContainerConfigurationException(message);
        }
    }

    public static void isConsolePortValid(String consolePort) throws AndroidContainerConfigurationException {
        Validate.notNullOrEmpty(consolePort, "console port to validate is null or empty.");
        try {
            long port = Long.parseLong(consolePort);
            if (port < 5554L || port > 5584L || port % 2L != 0L) {
                throw new AndroidContainerConfigurationException("Console port is not in the right range or it is not an even number. It has to be in the range 5554-5584.");
            }
        }
        catch (NumberFormatException e) {
            throw new AndroidContainerConfigurationException("Unable to get console port number from the string '" + consolePort + "'.");
        }
    }

    public static void isAdbPortValid(String adbPort) throws AndroidContainerConfigurationException {
        Validate.notNullOrEmpty(adbPort, "adb port to validate is null or empty");
        try {
            long port = Long.parseLong(adbPort);
            if (port < 5555L || port > 5585L || port % 2L != 1L) {
                throw new AndroidContainerConfigurationException("Adb port is not in the right range or it is not an odd number. It has to be in the range 5555-5585.");
            }
        }
        catch (NumberFormatException e) {
            throw new AndroidContainerConfigurationException("Unable to get adb port number from string '" + adbPort + "'.");
        }
    }

    public static boolean isPortValid(int port) {
        if (port <= 0 || port >= 65535) {
            throw new AndroidContainerConfigurationException("Ports have to be in range [0,65535].");
        }
        return true;
    }

    public static void sdCardFileName(String fileName, String message) throws AndroidContainerConfigurationException {
        Validate.notNullOrEmpty(fileName, "SD card file name to validate is null or empty string");
        Validate.notNullOrEmpty(message, "exception message can't be null or empty string");
        if (fileName.endsWith(System.getProperty("file.separator"))) {
            throw new AndroidContainerConfigurationException("File name of SD card can't end with system file separator. It denotes a directory and not a file!");
        }
        String[] tokens = new File(fileName).getName().split("\\.");
        if (tokens.length < 2 || !tokens[tokens.length - 1].equals("img") || tokens[0].trim().isEmpty()) {
            throw new AndroidContainerConfigurationException(message);
        }
    }

    public static void isWriteable(File file, String message) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException(message);
        }
        if (!file.exists() || !file.canWrite()) {
            throw new IllegalArgumentException(message);
        }
    }
}

