/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.droidium.container.utils.Monkey;

public class AndroidApplicationManager {
    private static final Logger logger = Logger.getLogger(AndroidApplicationManager.class.getName());
    private final AndroidDevice device;
    private final ProcessExecutor executor;
    private final AndroidSDK sdk;
    private static final String TOP_CMD = "top -n 1";
    private static final String PACKAGES_LIST_CMD = "pm list packages -f";

    public AndroidApplicationManager(AndroidDevice device, ProcessExecutor executor, AndroidSDK sdk) {
        Validate.notNull(device, "Android device you are trying to pass to Android application manager is a null object!");
        Validate.notNull(executor, "Process executor you are trying to pass to Android application manager is a null object!");
        Validate.notNull(sdk, "Android SDK you are trying to pass to Android application manager is a null object!");
        this.device = device;
        this.executor = executor;
        this.sdk = sdk;
    }

    public void install(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to pass is a null object!");
        Validate.notNull(deployment.getResignedApk(), "Application to install is a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package name is a null object!");
        Command installCommand = new Command();
        installCommand.add(this.sdk.getAdbPath()).add("-s").add(this.device.getSerialNumber()).add("install").add(deployment.getResignedApk().getAbsolutePath());
        logger.fine("AUT installation command: " + installCommand.toString());
        String applicationBasePackage = deployment.getApplicationBasePackage();
        try {
            this.executor.execute(installCommand.getAsArray());
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException("Installation of the application '" + applicationBasePackage + "' was interrupted.");
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException("Unable to execute installation command " + installCommand.getAsString() + " for the application " + applicationBasePackage);
        }
        if (!this.device.isPackageInstalled(applicationBasePackage)) {
            throw new AndroidExecutionException("Application " + applicationBasePackage + " was not installed on device " + this.device.getSerialNumber() + ".");
        }
    }

    public void uninstall(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to uninstall can not be a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package can not be a null object!");
        Command command = new Command().addAsString("pm uninstall " + deployment.getApplicationBasePackage());
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile(DroidiumFileUtils.getTmpDir()), command.getLast(), false);
            this.device.executeShellCommand(command.getAsString(), (AndroidDeviceOutputReciever)monkey);
            Monkey.wait(this.device, monkey, PACKAGES_LIST_CMD);
        }
        catch (IOException ex) {
            throw new AndroidExecutionException("Unable to uninstall application " + deployment.getApplicationBasePackage() + " from Android device.");
        }
    }

    public void disable(AndroidDeployment deployment) {
        Validate.notNull(deployment, "Android deployment you are trying to kill can not be a null object!");
        Validate.notNull(deployment.getApplicationBasePackage(), "Application base package name can not be a null object!");
        Command command = new Command().addAsString("pm disable " + deployment.getApplicationBasePackage());
        try {
            Monkey monkey = new Monkey(DroidiumFileUtils.createRandomEmptyFile(DroidiumFileUtils.getTmpDir()), command.getLast(), false);
            this.device.executeShellCommand(command.getAsString(), (AndroidDeviceOutputReciever)monkey);
            Monkey.wait(this.device, monkey, TOP_CMD);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to disable running application " + deployment.getApplicationBasePackage());
        }
    }
}

