/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.AndroidSDCardManager;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierType;
import org.arquillian.droidium.container.api.SDCard;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.impl.AndroidSDCard;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreated;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDelete;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDeleted;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidSDCardManagerImpl
implements AndroidSDCardManager {
    private static final Logger logger = Logger.getLogger(AndroidSDCardManagerImpl.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<IdentifierGenerator> idGenerator;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Event<AndroidSDCardCreated> androidSDCardCreated;
    @Inject
    private Event<AndroidSDCardDeleted> androidSDCardDeleted;
    private static final String SD_CARD_DEFAULT_DIR_PATH = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator");
    private static final String SD_CARD_DEFAULT_SIZE = "128M";

    public void createSDCard(@Observes AndroidSDCardCreate event) throws AndroidExecutionException {
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDCard sdCard = new AndroidSDCard();
        sdCard.setFileName(configuration.getSdCard());
        sdCard.setGenerated(configuration.getGenerateSDCard());
        sdCard.setLabel(configuration.getSdCardLabel());
        sdCard.setSize(configuration.getSdSize());
        sdCard.setGenerated(configuration.getGenerateSDCard());
        if (sdCard.getLabel() == null) {
            String sdCardLabel = ((IdentifierGenerator)this.idGenerator.get()).getIdentifier(IdentifierType.SD_CARD_LABEL.getClass());
            sdCard.setLabel(sdCardLabel);
        }
        if (sdCard.getSize() == null) {
            sdCard.setSize(SD_CARD_DEFAULT_SIZE);
        }
        if (sdCard.isGenerated()) {
            if (sdCard.getFileName() == null) {
                String sdCardName = SD_CARD_DEFAULT_DIR_PATH + ((IdentifierGenerator)this.idGenerator.get()).getIdentifier(IdentifierType.SD_CARD.getClass());
                sdCard.setFileName(sdCardName);
                configuration.setSdCard(sdCardName);
                this.createSDCard(sdCard);
                this.androidSDCardCreated.fire((Object)new AndroidSDCardCreated());
            } else if (new File(sdCard.getFileName()).exists()) {
                configuration.setGenerateSDCard(false);
                sdCard.setGenerated(false);
            } else {
                this.createSDCard(sdCard);
                this.androidSDCardCreated.fire((Object)new AndroidSDCardCreated());
            }
        } else if (sdCard.getFileName() != null) {
            if (new File(sdCard.getFileName()).exists()) {
                logger.log(Level.INFO, "Using SD card at " + sdCard.getFileName());
            } else {
                logger.log(Level.INFO, "SD card you specified does not exist (" + sdCard.getFileName() + ") and its " + "generation is set to false. Default system SD card for Android emulator will be used.");
            }
        }
    }

    public void deleteSDCard(@Observes AndroidSDCardDelete event) {
        AndroidSDCard sdCard = new AndroidSDCard();
        sdCard.setFileName(((AndroidContainerConfiguration)this.configuration.get()).getSdCard());
        sdCard.setGenerated(((AndroidContainerConfiguration)this.configuration.get()).getGenerateSDCard());
        try {
            if (sdCard.getFileName() != null && sdCard.isGenerated()) {
                this.deleteSDCard(sdCard);
                this.androidSDCardDeleted.fire((Object)new AndroidSDCardDeleted());
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to delete SD card", e);
        }
    }

    public void createSDCard(SDCard sdCard) throws AndroidExecutionException {
        AndroidSDCard androidSDCard = (AndroidSDCard)sdCard;
        ProcessExecutor executor = (ProcessExecutor)this.executor.get();
        Process sdCardProcess = this.constructCreateSdCardProcess(executor, sdCard);
        if (this.createSDCard(sdCardProcess, executor) == 0) {
            logger.log(Level.INFO, "Android SD card labelled {0} located at {1} with size of {2} was created.", new Object[]{androidSDCard.getLabel(), androidSDCard.getFileName(), androidSDCard.getSize()});
        } else {
            logger.log(Level.INFO, "Unable to create SD card labelled {0} located at {1} with size of {2}.", new Object[]{androidSDCard.getLabel(), androidSDCard.getFileName(), androidSDCard.getSize()});
        }
    }

    public void deleteSDCard(SDCard sdCard) {
        AndroidSDCard androidSdCard = (AndroidSDCard)sdCard;
        if (androidSdCard.getFileName() != null && androidSdCard.isGenerated()) {
            if (new File(androidSdCard.getFileName()).delete()) {
                logger.log(Level.INFO, "Android SD card labelled {0} located at {1} was deleted", new Object[]{androidSdCard.getLabel(), androidSdCard.getFileName()});
            } else {
                logger.log(Level.INFO, "Unable to delete android SD card labelled {0} located at {1}.", new Object[]{androidSdCard.getLabel(), androidSdCard.getFileName()});
            }
        }
    }

    private int createSDCard(final Process sdCardProcess, ProcessExecutor executor) throws AndroidExecutionException {
        try {
            int created = executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return sdCardProcess.waitFor();
                }
            }).get();
            return created;
        }
        catch (Exception ex) {
            throw new AndroidExecutionException((Throwable)ex);
        }
    }

    private Process constructCreateSdCardProcess(ProcessExecutor executor, SDCard sdCard) throws AndroidExecutionException {
        AndroidSDCard androidSDCard = (AndroidSDCard)sdCard;
        Command command = new Command();
        command.add(((AndroidSDK)this.androidSDK.get()).getMakeSdCardPath()).add("-l").add(androidSDCard.getLabel()).add(androidSDCard.getSize()).add(androidSDCard.getFileName());
        try {
            return executor.spawn(command.getAsList());
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException();
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException();
        }
    }
}

