/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.RawImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.Screenshooter;
import org.arquillian.droidium.container.api.Screenshot;
import org.arquillian.droidium.container.api.ScreenshotType;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.AndroidScreenshot;
import org.arquillian.droidium.container.utils.AndroidScreenshotIdentifierGenerator;

public class AndroidScreenshooter
implements Screenshooter {
    private static final Logger log = Logger.getLogger(AndroidScreenshooter.class.getName());
    private String screenshotTargetDir = "target" + System.getProperty("file.separator");
    private ScreenshotType screenshotType = ScreenshotType.PNG;
    private AndroidDevice device;

    public AndroidScreenshooter(AndroidDevice device) {
        Validate.notNull(device, "Android device you try to get into Android screenshooter can not be a null object!");
        this.device = device;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScreenshotTargetDir(String screenshotTargetDir) {
        Validate.notNullOrEmpty(screenshotTargetDir, "Screenshot target directory can not be a null object or an empty string");
        File file = new File(screenshotTargetDir);
        if (!file.exists()) {
            if (!file.mkdirs()) throw new IllegalArgumentException("Unable to create screenshot target dir " + file.getAbsolutePath());
            this.screenshotTargetDir = screenshotTargetDir;
            log.info("Created screenshot target directory: " + file.getAbsolutePath());
            return;
        } else {
            Validate.isReadableDirectory(screenshotTargetDir, "want-to-be target screenshot directory path exists and is not a directory");
            this.screenshotTargetDir = screenshotTargetDir;
        }
    }

    public Screenshot takeScreenshot() {
        return this.takeScreenshot(null, this.getScreenshotImageFormat());
    }

    public Screenshot takeScreenshot(String fileName) {
        return this.takeScreenshot(fileName, this.getScreenshotImageFormat());
    }

    public Screenshot takeScreenshot(ScreenshotType type) {
        return this.takeScreenshot(null, type);
    }

    public Screenshot takeScreenshot(String fileName, ScreenshotType type) {
        if (fileName != null && fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("The file name to save a screenshot to can not be an empty string.");
        }
        if (!this.device.isOnline()) {
            throw new AndroidExecutionException("Android device is not online, can not take any screenshots.");
        }
        AndroidScreenshot screenshot = (AndroidScreenshot)this.device.getScreenshot();
        RawImage rawImage = screenshot.getRawImage();
        if (rawImage == null) {
            throw new AndroidExecutionException("Unable to get screenshot of underlying Android device.");
        }
        BufferedImage bufferedImage = new BufferedImage(rawImage.width, rawImage.height, 1);
        int index = 0;
        int indexInc = rawImage.bpp >> 3;
        for (int y = 0; y < rawImage.height; ++y) {
            int x = 0;
            while (x < rawImage.width) {
                int value = rawImage.getARGB(index);
                bufferedImage.setRGB(x, y, value);
                ++x;
                index += indexInc;
            }
        }
        String imageName = null;
        imageName = fileName == null ? new AndroidScreenshotIdentifierGenerator().getIdentifier(type.getClass()) : fileName + "." + type.toString();
        File image = new File(this.screenshotTargetDir, imageName);
        try {
            ImageIO.write((RenderedImage)bufferedImage, type.toString(), image);
        }
        catch (IOException e) {
            log.info("unable to save screenshot of type " + type.toString() + " to file " + image.getAbsolutePath());
            e.printStackTrace();
        }
        screenshot.setScreenshot(image);
        return screenshot;
    }

    public void setScreensthotImageFormat(ScreenshotType type) {
        Validate.notNull(type, "Screenshot format to set can not be a null object!");
        this.screenshotType = type;
    }

    private ScreenshotType getScreenshotImageFormat() {
        return this.screenshotType;
    }
}

