/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.log.LogcatHelper;
import org.arquillian.droidium.container.spi.event.AndroidBridgeTerminated;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidLogInitializer {
    private static final Logger logger = Logger.getLogger(AndroidLogInitializer.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<LogcatReader> logcat;
    @Inject
    @ContainerScoped
    private InstanceProducer<LogcatHelper> logcatHelper;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    private Future<Void> logcatFuture;

    public void initAndroidLog(@Observes AndroidDeviceReady event) {
        logger.info("Initializing Android LogcatReader");
        ProcessExecutor executor = (ProcessExecutor)this.executor.get();
        if (this.logcatHelper.get() == null) {
            this.logcatHelper.set((Object)new LogcatHelper((AndroidContainerConfiguration)this.configuration.get(), (AndroidDevice)this.androidDevice.get()));
        }
        LogcatReader logcat = new LogcatReader((AndroidContainerConfiguration)this.configuration.get(), (AndroidSDK)this.androidSDK.get(), (AndroidDevice)this.androidDevice.get());
        logcat.setWriter(((LogcatHelper)this.logcatHelper.get()).prepareWriter());
        this.logcatFuture = executor.submit(logcat);
        this.logcat.set((Object)logcat);
    }

    public void terminateAndroidLog(@Observes AndroidBridgeTerminated event) {
        this.logcatFuture.cancel(true);
        try {
            ((LogcatReader)this.logcat.get()).getWriter().close();
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public class LogcatReader
    implements Callable<Void> {
        private AndroidContainerConfiguration configuration;
        private AndroidSDK androidSDK;
        private AndroidDevice androidDevice;
        private Writer writer;
        private Pattern pattern;
        private List<String> whiteList = new ArrayList<String>();
        private List<String> blackList = new ArrayList<String>();
        private Map<Integer, String> processMap = new HashMap<Integer, String>();

        public LogcatReader(AndroidContainerConfiguration configuration, AndroidSDK androidSDK, AndroidDevice androidDevice) {
            this.configuration = configuration;
            this.androidSDK = androidSDK;
            this.androidDevice = androidDevice;
            if (configuration.getLogPackageWhitelist() != null) {
                String[] whiteList;
                for (String packageName : whiteList = configuration.getLogPackageWhitelist().split(",")) {
                    this.whiteList.add(this.escapePackageName(packageName));
                }
            }
            if (configuration.getLogPackageBlacklist() != null) {
                String[] blackList;
                for (String packageName : blackList = configuration.getLogPackageBlacklist().split(",")) {
                    this.blackList.add(this.escapePackageName(packageName));
                }
            }
        }

        @Override
        public Void call() throws Exception {
            if (this.writer == null) {
                return null;
            }
            try {
                Command command = new Command();
                command.add(this.androidSDK.getAdbPath()).add("-s").add(this.androidDevice.getSerialNumber()).add("logcat").add("-c");
                ProcessBuilder builder = new ProcessBuilder(command.getAsList());
                Process process = builder.start();
                command.clear();
                command.add(this.androidSDK.getAdbPath()).add("-s").add(this.androidDevice.getSerialNumber()).add("logcat").add("*:" + this.configuration.getLogLevel());
                builder = new ProcessBuilder(command.getAsList());
                process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!this.shouldWrite(line)) continue;
                    this.writer.write(line);
                    this.writer.flush();
                }
                this.writer.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error with logcat logging!", e);
            }
            return null;
        }

        private String escapePackageName(String packageName) {
            return packageName.replace("\\", "\\\\").replace(".", "\\.").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("?", "\\?").replace("+", "\\+").replace("*", ".*?");
        }

        private boolean shouldWrite(String line) {
            String processName;
            Matcher matcher;
            if (!this.configuration.isLogFilteringEnabled()) {
                return true;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile("./.+?\\(([\\s0-9]+?)\\):.*");
            }
            if (!(matcher = this.pattern.matcher(line)).matches()) {
                return false;
            }
            String processIdString = matcher.group(1).trim();
            Integer processId = Integer.valueOf(processIdString);
            if (!this.processMap.containsKey(processId)) {
                this.loadProcessMap();
            }
            if ((processName = this.processMap.get(processId)) == null) {
                processName = "";
            }
            for (String regex : this.whiteList) {
                if (!processName.matches(regex)) continue;
                return true;
            }
            for (String regex : this.blackList) {
                if (!processName.matches(regex)) continue;
                return false;
            }
            return true;
        }

        private void loadProcessMap() {
            try {
                this.processMap.clear();
                Command command = new Command();
                command.add(this.androidSDK.getAdbPath()).add("-s").add(this.androidDevice.getSerialNumber()).add("shell").add("ps");
                ProcessBuilder processBuilder = new ProcessBuilder(command.getAsList());
                Process process = processBuilder.start();
                Pattern pattern = Pattern.compile(".*?\\s+([0-9]+)\\s+[0-9]+\\s+[0-9]+\\s+[0-9]+\\s+[0-9a-f]+\\s+[0-9a-f]+\\s.?\\s(.*)");
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    Integer processId = Integer.valueOf(matcher.group(1));
                    String processName = matcher.group(2);
                    this.processMap.put(processId, processName);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Couldn't load process map!", e);
            }
        }

        public AndroidContainerConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(AndroidContainerConfiguration configuration) {
            this.configuration = configuration;
        }

        public AndroidSDK getAndroidSDK() {
            return this.androidSDK;
        }

        public void setAndroidSDK(AndroidSDK androidSDK) {
            this.androidSDK = androidSDK;
        }

        public AndroidDevice getAndroidDevice() {
            return this.androidDevice;
        }

        public void setAndroidDevice(AndroidDevice androidDevice) {
            this.androidDevice = androidDevice;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public void setWriter(Writer writer) {
            this.writer = writer;
        }
    }
}

