/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.log.LogLevel;
import org.arquillian.droidium.container.log.LogType;
import org.arquillian.droidium.container.utils.AndroidIdentifierGenerator;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class AndroidContainerConfiguration
implements ContainerConfiguration {
    private String fileSeparator = System.getProperty("file.separator");
    private static final Logger logger = Logger.getLogger(AndroidContainerConfiguration.class.getName());
    private boolean forceNewBridge = true;
    private String serialId;
    private String avdName;
    private String emulatorOptions;
    private String sdSize = "128M";
    private String sdCard;
    private String sdCardLabel;
    private boolean generateSDCard;
    private String abi;
    private long emulatorBootupTimeoutInSeconds = 120L;
    private long emulatorShutdownTimeoutInSeconds = 60L;
    private String androidHome = this.resolveAndroidHome();
    private String androidSdkHome = this.resolveAndroidSdkHome();
    private String javaHome = this.resolveJavaHome();
    private boolean avdGenerated;
    private String consolePort;
    private String adbPort;
    private int droneHostPort = 14444;
    private int droneGuestPort = 8080;
    private String logLevel = LogLevel.DEFAULT;
    private String logType = LogType.DEFAULT;
    private String logFilePath = "target" + this.fileSeparator + "logcat.log";
    private String logPackageWhitelist;
    private String logPackageBlacklist;
    private String keystore = null;
    private String storepass = "android";
    private String keypass = "android";
    private String alias = "androiddebugkey";
    private String sigalg = "SHA1withRSA";
    private String keyalg = "RSA";
    private boolean removeTmpDir = true;
    private String tmpDir = this.resolveTmpDir();
    private boolean logSerialId;
    private String apiLevel;

    public String getAndroidSdkHome() {
        return this.androidSdkHome;
    }

    public void setAndroidSdkHome(String androidSdkHome) {
        this.androidSdkHome = androidSdkHome;
    }

    public String getAndroidHome() {
        return this.androidHome;
    }

    public void setAndroidHome(String androidHome) {
        this.androidHome = androidHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public void setAvdName(String avdName) {
        this.avdName = avdName;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getEmulatorOptions() {
        return this.emulatorOptions;
    }

    public void setEmulatorOptions(String emulatorOptions) {
        this.emulatorOptions = emulatorOptions;
    }

    public boolean isForceNewBridge() {
        return this.forceNewBridge;
    }

    public void setForceNewBridge(boolean force) {
        this.forceNewBridge = force;
    }

    public long getEmulatorBootupTimeoutInSeconds() {
        return this.emulatorBootupTimeoutInSeconds;
    }

    public void setEmulatorBootupTimeoutInSeconds(long emulatorBootupTimeoutInSeconds) {
        this.emulatorBootupTimeoutInSeconds = emulatorBootupTimeoutInSeconds;
    }

    public String getApiLevel() {
        return this.apiLevel;
    }

    public void setApiLevel(String apiLevel) {
        this.apiLevel = apiLevel;
    }

    public String getSdSize() {
        return this.sdSize;
    }

    public void setSdSize(String sdSize) {
        this.sdSize = sdSize;
    }

    public String getSdCard() {
        return this.sdCard;
    }

    public String getSdCardLabel() {
        return this.sdCardLabel;
    }

    public void setSdCardLabel(String sdCardLabel) {
        this.sdCardLabel = sdCardLabel;
    }

    public boolean getGenerateSDCard() {
        return this.generateSDCard;
    }

    public void setGenerateSDCard(boolean generate) {
        this.generateSDCard = generate;
    }

    public void setSdCard(String sdCard) {
        this.sdCard = sdCard;
    }

    public long getEmulatorShutdownTimeoutInSeconds() {
        return this.emulatorShutdownTimeoutInSeconds;
    }

    public void setEmulatorShutdownTimeoutInSeconds(long emulatorShutdownTimeoutInSeconds) {
        this.emulatorShutdownTimeoutInSeconds = emulatorShutdownTimeoutInSeconds;
    }

    public String getAbi() {
        return this.abi;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public boolean isAVDGenerated() {
        return this.avdGenerated;
    }

    public void setAvdGenerated(boolean generated) {
        this.avdGenerated = generated;
    }

    public boolean getAvdGenerated() {
        return this.avdGenerated;
    }

    public String getConsolePort() {
        return this.consolePort;
    }

    public void setConsolePort(String consolePort) {
        this.consolePort = consolePort;
    }

    public String getAdbPort() {
        return this.adbPort;
    }

    public void setAdbPort(String adbPort) {
        this.adbPort = adbPort;
    }

    public int getDroneHostPort() {
        return this.droneHostPort;
    }

    public int getDroneGuestPort() {
        return this.droneGuestPort;
    }

    public void setDroneHostPort(int droneHostPort) {
        this.droneHostPort = droneHostPort;
    }

    public void setDroneGuestPort(int droneGuestPort) {
        this.droneGuestPort = droneGuestPort;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getLogPackageWhitelist() {
        return this.logPackageWhitelist;
    }

    public void setLogPackageWhitelist(String logPackageWhitelist) {
        this.logPackageWhitelist = logPackageWhitelist;
    }

    public String getLogPackageBlacklist() {
        return this.logPackageBlacklist;
    }

    public void setLogPackageBlacklist(String logPackageBlacklist) {
        this.logPackageBlacklist = logPackageBlacklist;
    }

    public boolean isLogFilteringEnabled() {
        return this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") || this.logPackageBlacklist != null && !this.logPackageBlacklist.equals("");
    }

    public boolean isLogSerialId() {
        return this.logSerialId;
    }

    public void setLogSerialId(boolean logSerialId) {
        this.logSerialId = logSerialId;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public String getKeyalg() {
        return this.keyalg;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public boolean getRemoveTmpDir() {
        return this.removeTmpDir;
    }

    public void setRemoveTmpDir(boolean removeTmpDir) {
        this.removeTmpDir = removeTmpDir;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    public String resolveJavaHome() {
        String JAVA_HOME_ENV = System.getenv("JAVA_HOME");
        String JAVA_HOME_PROPERTY = System.getProperty("java.home");
        return this.checkSlash(JAVA_HOME_PROPERTY == null ? JAVA_HOME_ENV : JAVA_HOME_PROPERTY);
    }

    public String resolveAndroidHome() {
        String ANDROID_HOME_ENV = System.getenv("ANDROID_HOME");
        String ANDROID_HOME_PROPERTY = System.getProperty("android.home");
        return this.checkSlash(ANDROID_HOME_PROPERTY == null ? ANDROID_HOME_ENV : ANDROID_HOME_PROPERTY);
    }

    public String resolveUserHome() {
        String USER_HOME_ENV = System.getenv("HOME");
        String USER_HOME_PROPERTY = System.getProperty("user.home");
        return this.checkSlash(USER_HOME_PROPERTY == null ? USER_HOME_ENV : USER_HOME_PROPERTY);
    }

    public String resolveAndroidSdkHome() {
        String ANDROID_SDK_HOME_ENV = System.getenv("ANDROID_SDK_HOME");
        String ANDROID_SDK_HOME_PROPERTY = System.getProperty("android.sdk.home");
        return this.checkSlash(ANDROID_SDK_HOME_PROPERTY == null ? (ANDROID_SDK_HOME_ENV == null ? this.resolveUserHome() : ANDROID_SDK_HOME_ENV) : ANDROID_SDK_HOME_PROPERTY);
    }

    public String resolveTmpDir() {
        String TMP_DIR_PROPERTY;
        String TMP_DIR_ENV = System.getenv("TMPDIR");
        if (TMP_DIR_ENV == null) {
            TMP_DIR_ENV = System.getenv("TEMP");
        }
        if (TMP_DIR_ENV == null) {
            TMP_DIR_ENV = System.getenv("TMP");
        }
        return this.checkSlash((TMP_DIR_PROPERTY = System.getProperty("java.io.tmpdir")) == null ? TMP_DIR_ENV : TMP_DIR_PROPERTY);
    }

    public void validate() throws AndroidContainerConfigurationException {
        if (this.getAndroidHome() == null) {
            throw new AndroidContainerConfigurationException("You have not set ANDROID_HOME environment property nor android.home system property. System property gets precedence.");
        }
        this.setAndroidHome(this.checkSlash(this.getAndroidHome()));
        if (this.getJavaHome() == null) {
            throw new AndroidContainerConfigurationException("You have not set JAVA_HOME environment property nor java.home system property. System property gets precedence.");
        }
        this.setJavaHome(this.checkSlash(this.getJavaHome()));
        this.setAndroidSdkHome(this.checkSlash(this.androidSdkHome));
        Validate.isReadableDirectory(this.androidSdkHome, "You must provide Android SDK home directory. The value you've provided is not valid. You can either set it via an environment variable ANDROID_SDK_HOME or via property called \"androidSdkHome\" in Arquillian configuration or you can set it as system property \"android.sdk.home\". When this property is not specified anywhere, it defaults to \"" + this.resolveUserHome() + "\"");
        Validate.isReadableDirectory(this.androidHome, "You must provide Android home directory. The value you have provided is not valid. You can either set it via environment variable ANDROID_HOME or via property called \"androidHome\" in Arquillian configuration or you can set it as system property \"android.home\".");
        if (this.avdName != null && this.serialId != null) {
            logger.warning("Both \"avdName\" and \"serialId\" properties are defined, the device specified by \"serialId\" will get priority if connected.");
        } else if (this.avdName == null) {
            this.avdName = UUID.randomUUID().toString();
        }
        if (this.consolePort != null) {
            Validate.isConsolePortValid(this.consolePort);
        }
        if (this.adbPort != null) {
            Validate.isAdbPortValid(this.adbPort);
        }
        if (this.sdCard != null) {
            Validate.sdCardFileName(this.sdCard, "File name (or path) of SD card to use '" + this.sdCard + "' is not valid. Check it is under existing and writable directory does have '.img' suffix.");
        }
        if (this.sdCardLabel != null) {
            Validate.notNullOrEmpty(this.sdCardLabel, "SD card label can not be the empty string");
        }
        if (this.sdSize != null) {
            Validate.sdSize(this.sdSize, "Check you did specify your sdSize property in arquillian.xml properly.");
        }
        if (this.droneHostPort != 14444) {
            Validate.isPortValid(this.droneHostPort);
        }
        if (this.droneGuestPort != 8080) {
            Validate.isPortValid(this.droneGuestPort);
        }
        if (this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") && this.logPackageBlacklist == null) {
            this.logPackageBlacklist = "*";
            logger.warning("\"logPackageBlacklist\" isn't defined, but \"logPackageWhitelist\" is. Assuming \"*\" as a value for \"logPackageBlacklist\"!");
        }
        if (this.emulatorBootupTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator bootup timeout has to be bigger then 0.");
        }
        if (this.emulatorShutdownTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator shutdown timeout has to be bigger then 0.");
        }
        File tmpDir = new File(this.getTmpDir() + new AndroidIdentifierGenerator().getIdentifier(FileType.FILE));
        this.setTmpDir(tmpDir.getAbsolutePath());
        if (!tmpDir.exists()) {
            DroidiumFileUtils.createTmpDir(tmpDir);
        }
        if (this.keystore == null) {
            this.keystore = this.getAndroidSdkHome() + ".android" + this.fileSeparator + "debug.keystore";
        }
        try {
            Validate.isReadable(this.getKeystore(), "Key store for Android APKs is not readable. File does not exist or you have no read access to this file. In case it does not exist, Arquillian Droidium native plugin tries to create keystore you specified dynamically in the file " + this.getKeystore());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Validate.notNullOrEmpty(this.getAlias(), "You must provide valid alias for signing of APK files. You entered '" + this.getAlias() + "'.");
        Validate.notNullOrEmpty(this.getKeypass(), "You must provide valid keypass for signing of APK files. You entered '" + this.getKeypass() + "'.");
        Validate.notNullOrEmpty(this.getStorepass(), "You must provide valid storepass for signing of APK files. You entered '" + this.getStorepass() + "'.");
        Validate.notNullOrEmpty(this.getKeyalg(), "You must provide valid key algorithm for signing packages. You entered '" + this.getKeyalg() + "'.");
        Validate.notNullOrEmpty(this.getSigalg(), "You must provide valid key algoritm for signing packages. You entered '" + this.getSigalg() + "'.");
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HOME\t\t\t").append(this.resolveUserHome());
        sb.append("\nJAVA_HOME\t\t").append(this.javaHome);
        sb.append("\nANDROID_HOME\t\t").append(this.androidHome);
        sb.append("\nANDROID_SDK_HOME\t").append(this.androidSdkHome);
        sb.append("\navdName\t\t\t").append(this.avdName);
        sb.append("\nserialId\t\t").append(this.serialId);
        sb.append("\napiLevel\t\t").append(this.apiLevel);
        sb.append("\nabi\t\t\t").append(this.abi);
        sb.append("\nconsolePort\t\t").append(this.consolePort);
        sb.append("\nadbPort\t\t\t").append(this.adbPort);
        sb.append("\nemuBoot\t\t\t").append(this.emulatorBootupTimeoutInSeconds);
        sb.append("\nemuShut\t\t\t").append(this.emulatorShutdownTimeoutInSeconds);
        sb.append("\nemuOpts\t\t\t").append(this.emulatorOptions);
        sb.append("\nkeystore\t\t").append(this.keystore);
        sb.append("\nkeypass\t\t\t").append(this.keypass);
        sb.append("\nstorepass\t\t").append(this.storepass);
        sb.append("\nalias\t\t\t").append(this.alias);
        sb.append("\nsigalg\t\t\t").append(this.sigalg);
        sb.append("\nkeyalg\t\t\t").append(this.keyalg);
        sb.append("\nsdCard\t\t\t").append(this.sdCard);
        sb.append("\nsdSize\t\t\t").append(this.sdSize);
        sb.append("\ngenerateSD\t\t").append(this.generateSDCard);
        sb.append("\nlogLevel\t\t").append(this.logLevel);
        sb.append("\nlogType\t\t\t").append(this.logType);
        sb.append("\nlogFilePath\t\t").append(this.logFilePath);
        sb.append("\nlogPackageWhitelist\t").append(this.logPackageWhitelist);
        sb.append("\nlogPackageBlacklist\t").append(this.logPackageBlacklist);
        sb.append("\nremoveTmpDir\t\t").append(this.removeTmpDir);
        sb.append("\ntmpDir\t\t\t").append(this.tmpDir);
        sb.append("\nforce\t\t\t").append(this.forceNewBridge);
        return sb.toString();
    }

    public Map<String, String> getAndroidSystemEnvironmentProperties() {
        HashMap<String, String> androidEnvironmentProperties = new HashMap<String, String>();
        androidEnvironmentProperties.put("ANDROID_HOME", this.androidHome);
        androidEnvironmentProperties.put("ANDROID_SDK_HOME", this.androidSdkHome);
        return androidEnvironmentProperties;
    }

    private String checkSlash(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return path.endsWith(this.fileSeparator) ? path : path + this.fileSeparator;
    }
}

