/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DroidiumExtensionsValidation {
    private static final Logger logger = Logger.getLogger(DroidiumExtensionsValidation.class.getName());

    public void validateDescriptor(@Observes BeforeStart event, ArquillianDescriptor descriptor) {
        if (!event.getDeployableContainer().getConfigurationClass().equals(AndroidContainerConfiguration.class)) {
            return;
        }
        Map extensionProperties = null;
        for (ExtensionDef extension : descriptor.getExtensions()) {
            extensionProperties = extension.getExtensionProperties();
            if (!extension.getExtensionName().startsWith("webdriver") || (extensionProperties.get("browser") == null || !((String)extensionProperties.get("browser")).equals("android")) && (extensionProperties.get("browserName") == null || !((String)extensionProperties.get("browserName")).equals("android")) || this.isWebExtensionOnClassPath() || this.isNativeExtensionOnClassPath()) continue;
            logger.warning("You have Droidium container as well as webdriver extension with browser \"android\" configured in arquillian.xml but there is not Droidium native nor Droidium web extension on the class path. This setting is highly suspicious - it might not be wrong when you actually do not use Drone instance injected into test case for that extension however, in most cases, please add Droidium native OR web extension on class path to be able to test native Android applications or web applications from Android device.");
            break;
        }
    }

    private boolean isNativeExtensionOnClassPath() {
        try {
            Class.forName("org.arquillian.droidium.native_.DroidiumNativeExtension");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private boolean isWebExtensionOnClassPath() {
        try {
            Class.forName("org.arquillian.droidium.web.DroidiumWebExtension");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

