/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.AndroidBridgeImpl;
import org.arquillian.droidium.container.spi.event.AndroidBridgeInitialized;
import org.arquillian.droidium.container.spi.event.AndroidBridgeTerminated;
import org.arquillian.droidium.container.spi.event.AndroidContainerStart;
import org.arquillian.droidium.container.spi.event.AndroidEmulatorShuttedDown;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidBridgeConnector {
    private static final Logger logger = Logger.getLogger(AndroidBridgeConnector.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidBridge> androidBridge;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Event<AndroidBridgeInitialized> adbInitialized;
    @Inject
    private Event<AndroidBridgeTerminated> adbTerminated;

    public void initAndroidDebugBridge(@Observes AndroidContainerStart event) throws AndroidExecutionException {
        logger.info("Initializing Android Debug Bridge.");
        long start = System.currentTimeMillis();
        AndroidBridgeImpl bridge = new AndroidBridgeImpl(new File(((AndroidSDK)this.androidSDK.get()).getAdbPath()), ((AndroidContainerConfiguration)this.configuration.get()).isForceNewBridge());
        bridge.connect();
        long delta = System.currentTimeMillis() - start;
        logger.info("Android Debug Bridge was initialized in " + delta + "ms.");
        this.androidBridge.set((Object)bridge);
        this.adbInitialized.fire((Object)new AndroidBridgeInitialized());
    }

    public void terminateAndroidDebugBridge(@Observes AndroidEmulatorShuttedDown event) throws AndroidExecutionException {
        logger.info("Disconnecting Android Debug Bridge.");
        ((AndroidBridge)this.androidBridge.get()).disconnect();
        this.adbTerminated.fire((Object)new AndroidBridgeTerminated());
    }

    public void afterTerminateAndroidDebugBridge(@Observes AndroidBridgeTerminated event) {
        logger.info("Executing operations after disconnecting from Android Debug Bridge");
    }
}

