/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.Screenshooter;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.impl.AndroidDeviceImpl;
import org.arquillian.droidium.container.impl.AndroidEmulator;
import org.arquillian.droidium.container.impl.AndroidScreenshooter;
import org.arquillian.droidium.container.impl.CountDownWatch;
import org.arquillian.droidium.container.impl.ProcessExecution;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.impl.ProcessInteractionBuilder;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.utils.NetUtils;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidEmulatorStartup {
    private static final Logger logger = Logger.getLogger(AndroidEmulatorStartup.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidEmulator> androidEmulator;
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidDevice> androidDevice;
    @Inject
    @ContainerScoped
    private InstanceProducer<Screenshooter> screenshooter;
    @Inject
    private Instance<AndroidBridge> androidBridge;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Event<AndroidDeviceReady> androidDeviceReady;

    public void startAndroidEmulator(@Observes AndroidVirtualDeviceAvailable event) throws AndroidExecutionException {
        if (!((AndroidBridge)this.androidBridge.get()).isConnected()) {
            throw new IllegalStateException("Android debug bridge must be connected in order to spawn the emulator");
        }
        logger.log(Level.INFO, "Starting Android emulator of AVD name {0}.", ((AndroidContainerConfiguration)this.configuration.get()).getAvdName());
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidDevice emulator = null;
        CountDownWatch countdown = new CountDownWatch(configuration.getEmulatorBootupTimeoutInSeconds(), TimeUnit.SECONDS);
        logger.log(Level.INFO, "Waiting {0} seconds for emulator {1} to be started and connected.", new Object[]{countdown.timeout(), configuration.getAvdName()});
        ProcessExecutor emulatorProcessExecutor = (ProcessExecutor)this.executor.get();
        DeviceConnectDiscovery deviceDiscovery = new DeviceConnectDiscovery();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        ProcessExecution emulatorExecution = this.startEmulator(emulatorProcessExecutor);
        this.androidEmulator.set((Object)new AndroidEmulator(emulatorExecution));
        logger.log(Level.INFO, "Emulator process started, {0} seconds remaining to start the device {1}", new Object[]{countdown.timeLeft(), configuration.getAvdName()});
        this.waitUntilBootUpIsComplete(deviceDiscovery, emulatorExecution, emulatorProcessExecutor, countdown);
        this.unlockEmulator(deviceDiscovery, emulatorProcessExecutor);
        emulator = deviceDiscovery.getDiscoveredDevice();
        this.setDronePorts(emulator);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        this.androidDevice.set((Object)emulator);
        this.screenshooter.set((Object)new AndroidScreenshooter(emulator));
        this.androidDeviceReady.fire((Object)new AndroidDeviceReady(emulator));
    }

    private void setDronePorts(AndroidDevice device) {
        device.setDroneHostPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneHostPort());
        device.setDroneGuestPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneGuestPort());
    }

    private ProcessExecution startEmulator(ProcessExecutor executor) throws AndroidExecutionException {
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        Command command = new Command();
        command.add(sdk.getEmulatorPath()).add("-avd").add(configuration.getAvdName());
        if (configuration.getSdCard() != null) {
            command.add("-sdcard");
            command.add(configuration.getSdCard());
        }
        if (configuration.getConsolePort() != null && !NetUtils.isPortFree(configuration.getConsolePort())) {
            throw new AndroidExecutionException("It seems there is already something which listens on specified console port " + configuration.getConsolePort() + " so Droidium can not start emulator there.");
        }
        if (configuration.getAdbPort() != null && !NetUtils.isPortFree(configuration.getAdbPort())) {
            throw new AndroidExecutionException("It seems there is already something which listens on specified adb port " + configuration.getAdbPort() + " so Droidium can not start emulator there.");
        }
        if (configuration.getConsolePort() != null && configuration.getAdbPort() != null) {
            command.add("-ports").addAsString(configuration.getConsolePort() + "," + configuration.getAdbPort());
        } else if (configuration.getConsolePort() != null) {
            command.add("-port").add(configuration.getConsolePort());
        }
        command.addAsString(configuration.getEmulatorOptions());
        logger.log(Level.INFO, "Starting emulator \"{0}\", using {1}", new Object[]{configuration.getAvdName(), command});
        ProcessInteractionBuilder interactions = new ProcessInteractionBuilder().errors("^SDL init failure.*$").errors("^PANIC:.*$").errors("^error.*$");
        try {
            return executor.spawn(interactions.build(), command);
        }
        catch (AndroidExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to start emulator \"{0}\", using {1}", new Object[]{configuration.getAvdName(), command});
        }
    }

    private void unlockEmulator(DeviceConnectDiscovery deviceDiscovery, ProcessExecutor executor) {
        AndroidDevice connectedDevice = deviceDiscovery.getDiscoveredDevice();
        String serialNumber = connectedDevice.getSerialNumber();
        Command unlockPart1 = new Command(((AndroidSDK)this.androidSDK.get()).getAdbPath(), "-s", serialNumber, "shell", "input", "keyevent", "82");
        Command unlockPart2 = new Command(((AndroidSDK)this.androidSDK.get()).getAdbPath(), "-s", serialNumber, "shell", "input", "keyevent", "4");
        try {
            executor.execute(ProcessInteractionBuilder.NO_INTERACTION, unlockPart1);
            executor.execute(ProcessInteractionBuilder.NO_INTERACTION, unlockPart2);
        }
        catch (AndroidExecutionException e) {
            logger.log(Level.WARNING, "Unlocking device failed", e);
        }
    }

    private void waitUntilBootUpIsComplete(final DeviceConnectDiscovery deviceDiscovery, final ProcessExecution emulatorExecution, final ProcessExecutor executor, CountDownWatch countdown) throws AndroidExecutionException {
        try {
            boolean isOnline = executor.scheduleUntilTrue(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (emulatorExecution.isFinished()) {
                        throw new IllegalStateException("Emulator device startup exited prematurely with exit code " + emulatorExecution.getExitCode());
                    }
                    return deviceDiscovery.isOnline();
                }
            }, countdown.timeLeft(), countdown.getTimeUnit().convert(1L, TimeUnit.SECONDS), countdown.getTimeUnit());
            if (!isOnline) {
                throw new IllegalStateException("No emulator device was brough online during " + countdown.timeout() + " seconds to Android Debug Bridge. Please increase the time limit in order to get emulator connected.");
            }
            AndroidDevice connectedDevice = deviceDiscovery.getDiscoveredDevice();
            logger.log(Level.INFO, "Serial number: " + connectedDevice.getSerialNumber());
            final String adbPath = ((AndroidSDK)this.androidSDK.get()).getAdbPath();
            logger.log(Level.INFO, "adbPath: " + adbPath);
            final String serialNumber = connectedDevice.getSerialNumber();
            logger.log(Level.INFO, "serial number: " + serialNumber);
            isOnline = executor.scheduleUntilTrue(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (emulatorExecution.isFinished()) {
                        throw new IllegalStateException("Emulator device startup exited prematurely with exit code " + emulatorExecution.getExitCode());
                    }
                    Command propertiesCheck = new Command(adbPath, "-s", serialNumber, "shell", "getprop");
                    ProcessExecution properties = executor.execute(ProcessInteractionBuilder.NO_INTERACTION, propertiesCheck);
                    for (String line : properties.getOutput()) {
                        if (!line.contains("[ro.runtime.firstboot]")) continue;
                        return true;
                    }
                    return false;
                }
            }, countdown.timeLeft(), countdown.getTimeUnit().convert(1L, TimeUnit.SECONDS), countdown.getTimeUnit());
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Android emulator {0} was started within {1} seconds", new Object[]{connectedDevice.getAvdName(), countdown.timeElapsed()});
            }
            if (!isOnline) {
                throw new AndroidExecutionException("Emulator device hasn't started properly in " + countdown.timeout() + " seconds. Please increase the time limit in order to get emulator booted.");
            }
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException((Throwable)e, "Emulator device startup failed.", new Object[0]);
        }
        catch (ExecutionException e) {
            logger.log(Level.INFO, e.getCause().toString());
            throw new AndroidExecutionException((Throwable)e, "Emulator device startup failed.", new Object[0]);
        }
    }

    private class DeviceConnectDiscovery
    implements AndroidDebugBridge.IDeviceChangeListener {
        private IDevice discoveredDevice;
        private boolean online;

        private DeviceConnectDiscovery() {
        }

        public void deviceChanged(IDevice device, int changeMask) {
            if (this.discoveredDevice.equals(device) && (changeMask & 1) == 1 && device.isOnline()) {
                this.online = true;
            }
        }

        public void deviceConnected(IDevice device) {
            this.discoveredDevice = device;
            logger.log(Level.INFO, "Discovered an emulator device id={0} connected to ADB bus", device.getSerialNumber());
        }

        public void deviceDisconnected(IDevice device) {
        }

        public AndroidDevice getDiscoveredDevice() {
            return new AndroidDeviceImpl(this.discoveredDevice);
        }

        public boolean isOnline() {
            return this.online;
        }
    }
}

