/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ProcessExecution {
    private final String processId;
    private final Process process;
    private final List<String> output;

    public ProcessExecution(Process process, String processId) {
        this.process = process;
        this.processId = processId;
        this.output = new ArrayList<String>();
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ProcessExecution appendOutput(String line) {
        this.output.add(line);
        return this;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public ProcessExecution replyWith(String reply) throws IOException {
        OutputStream ostream = this.process.getOutputStream();
        ostream.write(reply.getBytes());
        ostream.flush();
        return this;
    }

    public boolean isFinished() {
        try {
            this.process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int getExitCode() throws IllegalStateException {
        if (!this.isFinished()) {
            throw new IllegalStateException("Process " + this.processId + " is not yet finished");
        }
        return this.process.exitValue();
    }

    public boolean executionFailed() {
        return this.getExitCode() != 0;
    }
}

