/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.CountDownWatch;
import org.arquillian.droidium.container.impl.ProcessExecution;
import org.arquillian.droidium.container.impl.ProcessInteraction;
import org.arquillian.droidium.container.impl.ProcessInteractionBuilder;

public class ProcessExecutor {
    public static Map<String, String> ENVIRONMENT_PROPERTIES = null;
    private final ShutDownThreadHolder shutdownThreads;
    private final ExecutorService service;
    private final ScheduledExecutorService scheduledService;

    public ProcessExecutor(Map<String, String> environmentProperies) {
        Validate.notNull(environmentProperies, "Environment properties to set for ProcessExecutor is backed by null object!");
        Validate.notAllNullsOrEmpty(environmentProperies.values().toArray(new String[0]), "All entries in environment properies map have to have values which are not null objects nor empty strings!");
        this.shutdownThreads = new ShutDownThreadHolder();
        this.service = Executors.newCachedThreadPool();
        this.scheduledService = Executors.newScheduledThreadPool(1);
        ENVIRONMENT_PROPERTIES = environmentProperies;
    }

    public ProcessExecutor() {
        this(new HashMap<String, String>());
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.service.submit(callable);
    }

    public Boolean scheduleUntilTrue(Callable<Boolean> callable, long timeout, long step, TimeUnit unit) throws InterruptedException, ExecutionException {
        CountDownWatch countdown = new CountDownWatch(timeout, unit);
        while (countdown.timeLeft() > 0L) {
            ScheduledFuture<Boolean> future = this.scheduledService.schedule(callable, step, unit);
            Boolean result = false;
            try {
                result = (Boolean)future.get(countdown.timeLeft(), unit);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (TimeoutException e) {
            }
        }
        return false;
    }

    public ProcessExecution spawn(ProcessInteraction interaction, Command command) throws AndroidExecutionException {
        try {
            Future<Process> processFuture = this.service.submit(new SpawnedProcess(true, command));
            Process process = processFuture.get();
            ProcessExecution execution = new ProcessExecution(process, command.get(0));
            this.service.submit(new ProcessOutputConsumer(execution, interaction));
            this.shutdownThreads.addHookFor(process);
            return execution;
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to spawn {0}, interrupted", new Object[]{command});
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to spawn {0}, failed", new Object[]{command});
        }
    }

    public ProcessExecution spawn(Command command) throws AndroidExecutionException {
        return this.spawn(ProcessInteractionBuilder.NO_INTERACTION, command);
    }

    public ProcessExecution execute(ProcessInteraction interaction, Command command) throws AndroidExecutionException {
        try {
            Future<Process> processFuture = this.service.submit(new SpawnedProcess(true, command));
            Process process = processFuture.get();
            ProcessExecution execution = this.service.submit(new ProcessOutputConsumer(new ProcessExecution(process, command.get(0)), interaction)).get();
            process.waitFor();
            if (execution.executionFailed()) {
                throw new AndroidExecutionException("Invocation of {0} failed with {1}", new Object[]{command, execution.getExitCode()});
            }
            return execution;
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to execute {0}, interrupted", new Object[]{command});
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to execute {0}, failed", new Object[]{command});
        }
    }

    public ProcessExecution execute(Command command) throws AndroidExecutionException {
        return this.execute(ProcessInteractionBuilder.NO_INTERACTION, command);
    }

    public ProcessExecutor removeShutdownHook(Process p) {
        this.shutdownThreads.removeHookFor(p);
        return this;
    }

    private static class ProcessOutputConsumer
    implements Callable<ProcessExecution> {
        private static final Logger log = Logger.getLogger(ProcessOutputConsumer.class.getName());
        private static final String NL = System.getProperty("line.separator");
        private final ProcessExecution execution;
        private final ProcessInteraction interaction;

        public ProcessOutputConsumer(ProcessExecution execution, ProcessInteraction interaction) {
            this.execution = execution;
            this.interaction = interaction;
        }

        @Override
        public ProcessExecution call() throws Exception {
            InputStream stream = this.execution.getProcess().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            try {
                int i;
                StringBuilder line = new StringBuilder();
                while ((i = reader.read()) != -1) {
                    char c = (char)i;
                    line.append(c);
                    String question = line.toString();
                    String answer = this.interaction.repliesTo(question);
                    if (answer != null) {
                        log.log(Level.FINEST, "{0} outputs: {1}, responded with: ", new Object[]{this.execution.getProcessId(), question, answer});
                        this.execution.replyWith(answer);
                    }
                    if (line.indexOf("\n") == -1 && line.indexOf(NL) == -1) continue;
                    String wholeLine = line.toString();
                    log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{this.execution.getProcessId(), wholeLine});
                    if (this.interaction.shouldOutput(wholeLine)) {
                        System.out.print(wholeLine);
                    }
                    if (this.interaction.shouldOutputToErr(wholeLine)) {
                        System.err.print("ERROR (" + this.execution.getProcessId() + "):" + wholeLine);
                    }
                    this.execution.appendOutput(wholeLine);
                    line = new StringBuilder();
                }
                if (line.length() > 1) {
                    String wholeLine = line.toString();
                    log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{this.execution.getProcessId(), wholeLine});
                    if (this.interaction.shouldOutput(wholeLine)) {
                        System.out.println(wholeLine);
                    }
                    if (this.interaction.shouldOutputToErr(wholeLine)) {
                        System.err.println("ERROR (" + this.execution.getProcessId() + "):" + wholeLine);
                    }
                    this.execution.appendOutput(wholeLine);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.execution;
        }
    }

    private static class SpawnedProcess
    implements Callable<Process> {
        private final Command command;
        private boolean redirectErrorStream;

        public SpawnedProcess(boolean redirectErrorStream, Command command) {
            this.redirectErrorStream = redirectErrorStream;
            this.command = command;
        }

        @Override
        public Process call() throws Exception {
            ProcessBuilder builder = new ProcessBuilder(this.command.getAsArray());
            builder.environment().putAll(ENVIRONMENT_PROPERTIES);
            builder.redirectErrorStream(this.redirectErrorStream);
            return builder.start();
        }
    }

    private static class ShutDownThreadHolder {
        private final Map<Process, Thread> shutdownThreads = Collections.synchronizedMap(new HashMap());

        public void addHookFor(final Process p) {
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (p != null) {
                        p.destroy();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            this.shutdownThreads.put(p, shutdownThread);
        }

        public void removeHookFor(Process p) {
            this.shutdownThreads.remove(p);
        }
    }
}

