/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.impl.ProcessInteraction;

public class ProcessInteractionBuilder {
    public static final ProcessInteraction NO_INTERACTION = new ProcessInteractionBuilder().build();
    private Map<String, String> replyMap = new LinkedHashMap<String, String>();
    private List<Pattern> allowedOutput = new ArrayList<Pattern>();
    private List<Pattern> errorOutput = new ArrayList<Pattern>();
    private Tuple tuple = new Tuple();

    public ProcessInteractionBuilder replyTo(String outputLine) {
        if (this.tuple.first != null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please append with(String) call");
        }
        this.tuple.first = outputLine;
        return this;
    }

    public ProcessInteractionBuilder with(String response) {
        if (this.tuple.first == null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please prepend replyTo(String) call");
        }
        this.tuple.last = response;
        this.replyMap.put(this.tuple.first, this.tuple.last);
        this.tuple = new Tuple();
        return this;
    }

    public ProcessInteractionBuilder outputs(String pattern) {
        Pattern p = Pattern.compile(pattern, 32);
        this.allowedOutput.add(p);
        return this;
    }

    public ProcessInteractionBuilder errors(String pattern) {
        Pattern p = Pattern.compile(pattern, 32);
        this.errorOutput.add(p);
        return this;
    }

    public ProcessInteraction build() {
        if (this.tuple.first != null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please append with(String) call");
        }
        return new ProcessInteractionImpl(this.replyMap, this.allowedOutput, this.errorOutput);
    }

    private static class ProcessInteractionImpl
    implements ProcessInteraction {
        private final Map<String, String> replyMap;
        private final List<Pattern> allowedOutput;
        private final List<Pattern> errorOutput;

        public ProcessInteractionImpl(Map<String, String> replyMap, List<Pattern> allowedOutput, List<Pattern> errorOutput) {
            this.replyMap = replyMap;
            this.allowedOutput = allowedOutput;
            this.errorOutput = errorOutput;
        }

        @Override
        public String repliesTo(String outputLine) {
            return this.replyMap.get(outputLine);
        }

        @Override
        public boolean shouldOutput(String outputLine) {
            for (Pattern p : this.allowedOutput) {
                if (!p.matcher(outputLine).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldOutputToErr(String outputLine) {
            for (Pattern p : this.errorOutput) {
                if (!p.matcher(outputLine).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static class Tuple {
        String first;
        String last;

        private Tuple() {
        }
    }
}

