/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierType;
import org.arquillian.droidium.container.utils.AndroidIdentifierGenerator;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class DroidiumFileUtils {
    private static final Logger logger = Logger.getLogger(DroidiumFileUtils.class.getName());
    private static File tmpDir = null;
    private static final IdentifierGenerator<FileType> aig = new AndroidIdentifierGenerator();

    public static void removeDir(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, "Unable to delete directory {0}. Reason: {1}", new Object[]{dir.getAbsolutePath(), ex.getMessage()});
        }
    }

    public static void removeDir(String dir) {
        DroidiumFileUtils.removeDir(new File(dir));
    }

    public static File getTmpDir() {
        return tmpDir;
    }

    public static void createTmpDir(File parent) {
        try {
            tmpDir = parent;
            tmpDir.mkdirs();
        }
        catch (SecurityException ex) {
            logger.severe("Security manager denies to create the working dir in " + parent.getAbsolutePath());
            throw new RuntimeException("Unable to create working directory in " + parent.getAbsolutePath());
        }
    }

    public static File createRandomEmptyFile(File parent) {
        File temp;
        try {
            while (!(temp = new File(parent, aig.getIdentifier((IdentifierType)FileType.FILE))).createNewFile()) {
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create file in " + parent.getAbsolutePath());
        }
        return temp;
    }

    public static File copyFileToDirectory(File src, File dest) {
        try {
            FileUtils.copyFileToDirectory((File)src, (File)dest);
            return new File(dest, src.getName());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to copy " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
    }

    public static String getRandomAPKFileName() {
        return aig.getIdentifier((IdentifierType)FileType.APK);
    }

    public static File export(Archive<?> fromArchive, File toFile) {
        if (toFile.exists() && toFile.isFile() && !toFile.delete()) {
            logger.fine("File to export the archive to exists and it can not be removed.");
        }
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            InputStream in = ((ZipExporter)fromArchive.as(ZipExporter.class)).exportAsInputStream();
            DroidiumFileUtils.write(in, out);
            DroidiumFileUtils.closeStream(in);
            DroidiumFileUtils.closeStream(out);
            return toFile;
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return null;
    }

    private static void write(InputStream input, OutputStream output) throws IOException {
        Validate.notNull((Object)input, (String)"InputStream to read from can not be null object!");
        Validate.notNull((Object)output, (String)"OutputStream to write to can not be null object!");
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = input.read(bytes)) != -1) {
            output.write(bytes, 0, read);
        }
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            stream = null;
        }
    }
}

