/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Validate;

public class AndroidSDK {
    private AndroidContainerConfiguration configuration;
    private static final Logger logger = Logger.getLogger(AndroidSDK.class.getName());
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String PLATFORM_TOOLS_FOLDER_NAME = "platform-tools";
    private static final String BUILD_TOOLS_FOLDER_NAME = "build-tools";
    private static final String SYSTEM_IMAGES_FOLDER_NAME = "system-images";
    private final File sdkPath;
    private final File javaPath;
    private final Platform platform;
    private List<Platform> availablePlatforms;

    public AndroidSDK(AndroidContainerConfiguration configuration) throws AndroidContainerConfigurationException {
        Validate.notNull(configuration, "AndroidSDK configuration must be provided");
        Validate.isReadableDirectory(configuration.getAndroidHome(), "Unable to read Android SDK from directory " + configuration.getAndroidHome());
        Validate.isReadableDirectory(configuration.getJavaHome(), "Unable to determine JAVA_HOME");
        this.sdkPath = new File(configuration.getAndroidHome());
        this.javaPath = new File(configuration.getJavaHome());
        this.availablePlatforms = this.findAvailablePlatforms();
        if (this.availablePlatforms.size() == 0) {
            throw new AndroidContainerConfigurationException("There are not any available platforms found on your system!");
        }
        Platform foundPlatform = null;
        if (configuration.getApiLevel() == null) {
            foundPlatform = this.availablePlatforms.get(this.availablePlatforms.size() - 1);
            configuration.setApiLevel(foundPlatform.apiLevel);
        } else {
            foundPlatform = this.findPlatformByApiLevel(configuration.getApiLevel());
        }
        if (foundPlatform == null) {
            logger.log(Level.INFO, "API level {0} you specified in configuration via 'apiLevel' property is not present on your system. In such case, Droidium tries to find the highest API level available and sets it as the default one. When your emulator of some AVD name is not present in the system, Droidium will create it dynamically and this API level will be used when emulator will be created. All available platforms are: {1}", new Object[]{configuration.getApiLevel(), this.getAllPlatforms()});
            foundPlatform = this.availablePlatforms.get(this.availablePlatforms.size() - 1);
            configuration.setApiLevel(foundPlatform.apiLevel);
        }
        if (foundPlatform.systemImages.size() == 0) {
            logger.log(Level.INFO, "There are not any system images found for your API level. You can use Droidium only with physical devices connected until you specify such API level which has system images available to use. Your current API level is: {0}", new Object[]{configuration.getApiLevel()});
        } else if (configuration.getAbi() == null) {
            configuration.setAbi(foundPlatform.systemImages.get(0));
        } else if (!foundPlatform.hasSystemImage(configuration.getAbi())) {
            logger.log(Level.INFO, "ABI you want to use ({1}), is not present in the system for API level {0}. Droidium uses whatever comes first among {2} and it is available for your API level.", new Object[]{configuration.getApiLevel(), configuration.getAbi(), SystemImage.getAll()});
            configuration.setAbi(foundPlatform.systemImages.get(0));
        }
        this.platform = foundPlatform;
        this.configuration = configuration;
    }

    private String getAllPlatforms() {
        StringBuilder sb = new StringBuilder();
        for (Platform p : this.availablePlatforms) {
            sb.append("API level: ").append(p.apiLevel).append("(").append(p.name).append("), ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(","), sb.length());
        }
        return sb.toString();
    }

    public AndroidContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AndroidContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    private Platform findPlatformByApiLevel(String apiLevel) {
        for (Platform p : this.availablePlatforms) {
            if (!p.apiLevel.equals(apiLevel)) continue;
            return p;
        }
        return null;
    }

    public Layout getLayout() throws AndroidContainerConfigurationException {
        Validate.isReadableDirectory(this.sdkPath, "Unable to read Android SDK from directory " + this.sdkPath);
        File platformTools = new File(this.sdkPath, PLATFORM_TOOLS_FOLDER_NAME);
        if (platformTools.exists() && platformTools.isDirectory()) {
            return Layout.LAYOUT_2_3;
        }
        File platforms = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        if (platforms.exists() && platforms.isDirectory()) {
            return Layout.LAYOUT_1_5;
        }
        throw new AndroidContainerConfigurationException("Android SDK could not be identified from path \"" + this.sdkPath + "\". ");
    }

    public String getPathForJavaTool(String tool) {
        File[] possiblePaths;
        for (File candidate : possiblePaths = new File[]{new File(this.javaPath, MessageFormat.format("bin/{0}", tool)), new File(this.javaPath, MessageFormat.format("bin/{0}.exe", tool)), new File(this.javaPath, MessageFormat.format("../bin/{0}", tool)), new File(this.javaPath, MessageFormat.format("../bin/{0}.exe", tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set JAVA_HOME environment property properly and that it points to your Java installation directory. ").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    public String getPathForTool(String tool) {
        File[] possiblePaths;
        for (File candidate : possiblePaths = new File[]{new File(this.sdkPath, MessageFormat.format("tools/{0}", tool)), new File(this.sdkPath, MessageFormat.format("tools/{0}.exe", tool)), new File(this.sdkPath, MessageFormat.format("tools/{0}.bat", tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.exe", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.bat", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", this.getPlatform().getName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORM_TOOLS_FOLDER_NAME, tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set ANDROID_HOME environment property or androidHome property in arquillian.xml and this location contains all required packages").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    private String getBuildTool(String tool) {
        File[] possiblePlatformPaths;
        for (File candidate : possiblePlatformPaths = new File[]{new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}", PLATFORMS_FOLDER_NAME, this.getPlatform(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.exe", PLATFORMS_FOLDER_NAME, this.getPlatform(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.bat", PLATFORMS_FOLDER_NAME, this.getPlatform(), tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        File possibleBuildPath = new File(this.sdkPath, BUILD_TOOLS_FOLDER_NAME);
        Object[] dirs = possibleBuildPath.listFiles();
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            for (File candidate : new File[]{new File((File)dir, tool), new File((File)dir, tool + ".exe"), new File((File)dir, tool + ".bat")}) {
                if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
                return candidate.getAbsolutePath();
            }
        }
        throw new RuntimeException("Could not find tool '" + tool + ".");
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getMakeSdCardPath() {
        return this.getPathForTool("mksdcard");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getAaptPath() {
        return this.getBuildTool("aapt");
    }

    public String getAndroidPath() {
        return this.getPathForTool("android");
    }

    public String getPathForFrameworkAidl() throws AndroidContainerConfigurationException {
        Layout layout = this.getLayout();
        switch (layout) {
            case LAYOUT_1_5: 
            case LAYOUT_2_3: {
                return this.getPlatform() + "/framework.aidl";
            }
        }
        throw new AndroidContainerConfigurationException("Unsupported layout \"" + (Object)((Object)layout) + "\"!");
    }

    public File getPlatform() {
        Validate.isReadableDirectory(this.sdkPath, "Unable to read Android SDK from directory " + this.sdkPath);
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        if (this.platform == null) {
            Object[] platformDirectories = platformsDirectory.listFiles();
            Arrays.sort(platformDirectories);
            return platformDirectories[platformDirectories.length - 1];
        }
        File platformDirectory = new File(this.platform.path);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        return platformDirectory;
    }

    private List<Platform> findAvailablePlatforms() throws AndroidContainerConfigurationException {
        ArrayList<Platform> availablePlatforms = new ArrayList<Platform>();
        List<File> platformDirectories = this.getPlatformDirectories();
        for (File pDir : platformDirectories) {
            File propFile = new File(pDir, SOURCE_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new AndroidContainerConfigurationException("Unable to read platform directory details from its configuration file " + propFile.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            List<String> systemImages = this.getSystemImages("android-" + apiLevel);
            Platform p = new Platform(platform, apiLevel, pDir.getAbsolutePath(), systemImages);
            availablePlatforms.add(p);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Found available platform: " + p.toString());
        }
        Collections.sort(availablePlatforms);
        return availablePlatforms;
    }

    private List<File> getPlatformDirectories() {
        File[] platformDirectories;
        ArrayList<File> sourcePropertyFiles = new ArrayList<File>();
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        for (File file : platformDirectories = platformsDirectory.listFiles()) {
            if (!file.isDirectory() || !file.getName().startsWith("android-")) continue;
            sourcePropertyFiles.add(file);
        }
        return sourcePropertyFiles;
    }

    private List<File> getSystemImageDirectories(String systemImageDirName) {
        ArrayList<File> systemImages = new ArrayList<File>();
        File dir = new File(new File(this.sdkPath, SYSTEM_IMAGES_FOLDER_NAME), systemImageDirName);
        if (!dir.exists()) {
            return systemImages;
        }
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            systemImages.add(file);
        }
        return systemImages;
    }

    private List<String> getSystemImages(String systemImageDirName) {
        List<File> systemImageDirs = this.getSystemImageDirectories(systemImageDirName);
        ArrayList<String> images = new ArrayList<String>();
        for (File dir : systemImageDirs) {
            images.add(dir.getName());
        }
        Collections.sort(images);
        Collections.reverse(images);
        return images;
    }

    public static enum Layout {
        LAYOUT_1_5,
        LAYOUT_2_3;

    }

    private static enum SystemImage {
        X86("x86"),
        ARMEABIV7A("armeabi-v7a"),
        MIPS("mips");

        private String name;

        private SystemImage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static String getAll() {
            StringBuilder sb = new StringBuilder();
            for (SystemImage systemImage : SystemImage.values()) {
                sb.append(systemImage.toString());
                sb.append(" ");
            }
            return sb.toString().trim();
        }
    }

    private static final class Platform
    implements Comparable<Platform> {
        final String name;
        final String apiLevel;
        final String path;
        final List<String> systemImages;

        public Platform(String name, String apiLevel, String path, List<String> systemImages) {
            this.name = name;
            this.apiLevel = apiLevel;
            this.path = path;
            this.systemImages = systemImages;
        }

        public boolean hasSystemImage(String systemImage) {
            for (String tmp : this.systemImages) {
                if (!tmp.equals(systemImage)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Platform o) {
            try {
                Integer current = Integer.parseInt(this.apiLevel);
                Integer other = Integer.parseInt(o.apiLevel);
                return current.compareTo(other);
            }
            catch (NumberFormatException e) {
                logger.log(Level.INFO, "Unable to compare platforms taking their api level as Integers, comparison as Strings follows");
                return this.apiLevel.compareTo(o.apiLevel);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.apiLevel == null ? 0 : this.apiLevel.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Platform other = (Platform)obj;
            if (this.apiLevel == null ? other.apiLevel != null : !this.apiLevel.equals(other.apiLevel)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Platform: ");
            sb.append(this.name).append("/API level ").append(this.apiLevel).append(" at ").append(this.path);
            return sb.toString();
        }
    }
}

