/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.arquillian.droidium.container.configuration.SecurityActions;
import org.arquillian.droidium.multiplecontainers.ContainerType;
import org.arquillian.droidium.multiplecontainers.MultipleLocalContainersRegistry;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class DroidiumExclusionDecider {
    private static final String DRONE_EXTENSION_CLASS_NAME = "org.jboss.arquillian.drone.DroneExtension";
    @Inject
    private Instance<ContainerRegistry> containerRegistry;

    public void decideDroidiumStart(@Observes(precedence=0x7FFFFFFF) BeforeSuite event, ArquillianDescriptor descriptor) {
        if (SecurityActions.isClassPresent(DRONE_EXTENSION_CLASS_NAME)) {
            List<ExtensionDef> webDriverExtensions = this.getWebDriverExtensions(descriptor);
            if (webDriverExtensions.isEmpty()) {
                return;
            }
            for (ExtensionDef webdriverExtension : webDriverExtensions) {
                if (!this.isAskingForAndroid(webdriverExtension)) continue;
                return;
            }
            ((MultipleLocalContainersRegistry)this.containerRegistry.get()).remove(ContainerType.ANDROID);
        }
    }

    private boolean isAskingForAndroid(ExtensionDef webdriverExtension) {
        for (Map.Entry entry : webdriverExtension.getExtensionProperties().entrySet()) {
            if (!((String)entry.getKey()).equals("browser") && !((String)entry.getKey()).equals("browserName") || !((String)entry.getValue()).equals("android")) continue;
            return true;
        }
        return false;
    }

    private List<ExtensionDef> getWebDriverExtensions(ArquillianDescriptor descriptor) {
        ArrayList<ExtensionDef> webDriverExtensions = new ArrayList<ExtensionDef>();
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extension.getExtensionName().startsWith("webdriver")) continue;
            webDriverExtensions.add(extension);
        }
        return webDriverExtensions;
    }
}

