/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.execution;

public class Answer
implements CharSequence {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private final AnswerType type;
    private final String answerText;
    private static final Answer EMPTY_ANSWER = new Answer(AnswerType.NONE, "");
    private static final Answer EOF = new Answer(AnswerType.EOF, "");

    public static Answer none() {
        return EMPTY_ANSWER;
    }

    public static Answer eof() {
        return EOF;
    }

    public static Answer text(String text) {
        return new Answer(AnswerType.TEXT, text + LINE_SEPARATOR);
    }

    private Answer(AnswerType type, String answerText) {
        this.type = type;
        this.answerText = answerText;
    }

    @Override
    public int length() {
        return this.answerText.length();
    }

    @Override
    public char charAt(int index) {
        return this.answerText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.answerText.subSequence(start, end);
    }

    public AnswerType getType() {
        return this.type;
    }

    public String getAnswerText() {
        return this.answerText;
    }

    public byte[] getBytes() {
        return this.answerText.getBytes();
    }

    @Override
    public String toString() {
        switch (this.type) {
            case NONE: {
                return "()";
            }
            case TEXT: {
                return this.answerText;
            }
            case EOF: {
                return "(-EOF-)" + LINE_SEPARATOR;
            }
        }
        throw new UnsupportedOperationException("Answer type " + (Object)((Object)this.type) + " is not supported");
    }

    public static enum AnswerType {
        NONE,
        TEXT,
        EOF;

    }
}

