/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.execution;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;

public class CountDownWatch {
    private long timeStart;
    private long timeout;
    private TimeUnit unit;

    public CountDownWatch(long timeout, TimeUnit unit) {
        if (EnumSet.of(TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS).contains((Object)unit)) {
            throw new IllegalArgumentException(MessageFormat.format("Time Unit {0} is not supported", new Object[]{unit}));
        }
        this.timeStart = System.currentTimeMillis();
        this.timeout = timeout;
        this.unit = unit;
    }

    public long timeLeft() {
        long currentTime = System.currentTimeMillis();
        long timeoutInMillis = TimeUnit.MILLISECONDS.convert(this.timeout, this.unit);
        return this.unit.convert(timeoutInMillis - (currentTime - this.timeStart), TimeUnit.MILLISECONDS);
    }

    public long timeElapsed() {
        long currentTime = System.currentTimeMillis();
        return this.unit.convert(currentTime - this.timeStart, TimeUnit.MILLISECONDS);
    }

    public void reset() {
        this.timeStart = System.currentTimeMillis();
    }

    public long timeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }
}

