/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.execution;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.droidium.container.execution.Answer;

public class ProcessExecution {
    private final String processId;
    private final Process process;
    private final List<String> output;
    private final OutputStream ostream;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public ProcessExecution(Process process, String processId, PrintStream stdout, PrintStream stderr) {
        this.process = process;
        this.processId = processId;
        this.output = new ArrayList<String>();
        this.ostream = new BufferedOutputStream(process.getOutputStream());
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProcessId() {
        return this.processId;
    }

    public ProcessExecution appendOutput(CharSequence line) {
        this.output.add(line.toString());
        return this;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public ProcessExecution replyWith(Answer reply) throws IOException {
        switch (reply.getType()) {
            case NONE: {
                return this;
            }
            case TEXT: {
                this.ostream.flush();
                this.ostream.write(reply.getBytes());
                this.ostream.flush();
                break;
            }
            case EOF: {
                this.ostream.flush();
                this.ostream.close();
            }
        }
        return this;
    }

    public boolean isFinished() {
        try {
            this.process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int getExitCode() throws IllegalStateException {
        if (!this.isFinished()) {
            throw new IllegalStateException("Process " + this.processId + " is not yet finished");
        }
        return this.process.exitValue();
    }

    public boolean executionFailed() {
        return this.getExitCode() != 0;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }
}

