/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.execution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.execution.Answer;
import org.arquillian.droidium.container.execution.CountDownWatch;
import org.arquillian.droidium.container.execution.ProcessExecution;
import org.arquillian.droidium.container.execution.ProcessExecutionException;
import org.arquillian.droidium.container.execution.ProcessInteraction;
import org.arquillian.droidium.container.execution.ProcessInteractionBuilder;
import org.arquillian.droidium.container.execution.Sentence;

public class ProcessExecutor {
    private final Map<String, String> environment;
    private final ShutDownThreadHolder shutdownThreads;
    private final ExecutorService service;
    private final ScheduledExecutorService scheduledService;

    public ProcessExecutor(Map<String, String> environmentProperies) {
        if (environmentProperies == null || environmentProperies.containsValue("")) {
            throw new IllegalStateException("All entries in environment properies map have to have values which are not null objects nor empty strings!");
        }
        this.shutdownThreads = new ShutDownThreadHolder();
        this.service = Executors.newCachedThreadPool();
        this.scheduledService = Executors.newScheduledThreadPool(1);
        this.environment = environmentProperies;
    }

    public ProcessExecutor() {
        this(new HashMap<String, String>());
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.service.submit(callable);
    }

    public Boolean scheduleUntilTrue(Callable<Boolean> callable, long timeout, long step, TimeUnit unit) throws InterruptedException, ExecutionException {
        CountDownWatch countdown = new CountDownWatch(timeout, unit);
        while (countdown.timeLeft() > 0L) {
            ScheduledFuture<Boolean> future = this.scheduledService.schedule(callable, step, unit);
            Boolean result = false;
            try {
                result = (Boolean)future.get(countdown.timeLeft(), unit);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (TimeoutException e) {
            }
        }
        return false;
    }

    public ProcessExecution spawn(ProcessInteraction interaction, String[] command) throws ProcessExecutionException {
        try {
            Future<Process> processFuture = this.service.submit(new SpawnedProcess(this.environment, true, command));
            Process process = processFuture.get();
            ProcessExecution execution = new ProcessExecution(process, command[0], System.out, System.err);
            this.service.submit(new ProcessOutputConsumer(execution, interaction));
            this.shutdownThreads.addHookFor(process);
            return execution;
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e, "Unable to spawn {0}, interrupted", new Object[]{command});
        }
        catch (ExecutionException e) {
            throw new ProcessExecutionException(e, "Unable to spawn {0}, failed", new Object[]{command});
        }
    }

    public ProcessExecution spawn(String ... command) throws ProcessExecutionException {
        return this.spawn(ProcessInteractionBuilder.NO_INTERACTION, command);
    }

    public ProcessExecution execute(ProcessInteraction interaction, String[] command) throws ProcessExecutionException {
        Process process = null;
        try {
            Future<Process> processFuture = this.service.submit(new SpawnedProcess(this.environment, true, command));
            process = processFuture.get();
            Future<ProcessExecution> executionFuture = this.service.submit(new ProcessOutputConsumer(new ProcessExecution(process, command[0], System.out, System.err), interaction));
            process.waitFor();
            ProcessExecution execution = executionFuture.get();
            if (execution.executionFailed()) {
                throw new ProcessExecutionException("Invocation of {0} failed with {1}", command, execution.getExitCode());
            }
            ProcessExecution processExecution = execution;
            return processExecution;
        }
        catch (InterruptedException e) {
            throw new ProcessExecutionException(e, "Unable to execute {0}, interrupted", new Object[]{command});
        }
        catch (ExecutionException e) {
            throw new ProcessExecutionException(e, "Unable to execute {0}, failed", new Object[]{command});
        }
        finally {
            if (process != null) {
                InputStream in = process.getInputStream();
                InputStream err = process.getErrorStream();
                OutputStream out = process.getOutputStream();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (IOException ignore) {}
                }
                process.destroy();
            }
        }
    }

    public ProcessExecution execute(String ... command) throws ProcessExecutionException {
        return this.execute(ProcessInteractionBuilder.NO_INTERACTION, command);
    }

    public ProcessExecutor removeShutdownHook(Process p) {
        this.shutdownThreads.removeHookFor(p);
        return this;
    }

    static class ProcessOutputConsumer
    implements Callable<ProcessExecution> {
        private static final Logger log = Logger.getLogger(ProcessOutputConsumer.class.getName());
        private final ProcessExecution execution;
        private final ProcessInteraction interaction;

        public ProcessOutputConsumer(ProcessExecution execution, ProcessInteraction interaction) {
            this.execution = execution;
            this.interaction = interaction;
        }

        @Override
        public ProcessExecution call() throws Exception {
            InputStream stream = this.execution.getProcess().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            if (!this.interaction.requiresInputInteraction()) {
                try {
                    this.execution.getProcess().getOutputStream().close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            try {
                int i;
                boolean reachedEOF = false;
                Sentence sentence = new Sentence();
                while (!reachedEOF && (i = reader.read()) != -1) {
                    sentence.append((char)i);
                    Answer answer = this.interaction.repliesTo(sentence);
                    switch (answer.getType()) {
                        case NONE: {
                            break;
                        }
                        case EOF: {
                            reachedEOF = true;
                        }
                        case TEXT: {
                            log.log(Level.FINEST, "({0}): {1} <= {2}", new Object[]{this.execution.getProcessId(), sentence, answer});
                            sentence.append(answer);
                            this.execution.replyWith(answer);
                        }
                    }
                    if (!sentence.isFinished()) continue;
                    sentence.trim();
                    log.log(Level.FINEST, "({0}): {1}", new Object[]{this.execution.getProcessId(), sentence});
                    if (this.interaction.shouldOutput(sentence)) {
                        this.execution.getStdout().println("(" + this.execution.getProcessId() + "):" + sentence);
                    }
                    if (this.interaction.shouldOutputToErr(sentence)) {
                        this.execution.getStderr().println("ERROR (" + this.execution.getProcessId() + "):" + sentence);
                    }
                    this.execution.appendOutput(sentence);
                    sentence.reset();
                }
                if (!sentence.isEmpty()) {
                    log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{this.execution.getProcessId(), sentence});
                    if (this.interaction.shouldOutput(sentence)) {
                        this.execution.getStdout().println("(" + this.execution.getProcessId() + "):" + sentence);
                    }
                    if (this.interaction.shouldOutputToErr(sentence)) {
                        this.execution.getStderr().println("ERROR (" + this.execution.getProcessId() + "):" + sentence);
                    }
                    this.execution.appendOutput(sentence);
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                OutputStream os = this.execution.getProcess().getOutputStream();
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.execution;
        }
    }

    private static class SpawnedProcess
    implements Callable<Process> {
        private final String[] command;
        private boolean redirectErrorStream;
        private Map<String, String> env;

        public SpawnedProcess(Map<String, String> env, boolean redirectErrorStream, String[] command) {
            this.env = env;
            this.redirectErrorStream = redirectErrorStream;
            this.command = command;
        }

        @Override
        public Process call() throws Exception {
            ProcessBuilder builder = new ProcessBuilder(this.command);
            builder.environment().putAll(this.env);
            builder.redirectErrorStream(this.redirectErrorStream);
            return builder.start();
        }
    }

    private static class ShutDownThreadHolder {
        private final Map<Process, Thread> shutdownThreads = Collections.synchronizedMap(new HashMap());

        public void addHookFor(final Process p) {
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (p != null) {
                        p.destroy();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            this.shutdownThreads.put(p, shutdownThread);
        }

        public void removeHookFor(Process p) {
            this.shutdownThreads.remove(p);
        }
    }
}

