/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.execution;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.execution.Answer;
import org.arquillian.droidium.container.execution.ProcessInteraction;
import org.arquillian.droidium.container.execution.Sentence;

public class ProcessInteractionBuilder {
    public static final ProcessInteraction NO_INTERACTION = new ProcessInteractionBuilder().build();
    private Map<Pattern, Answer> replyMap = new LinkedHashMap<Pattern, Answer>();
    private List<Pattern> allowedOutput = new ArrayList<Pattern>();
    private List<Pattern> errorOutput = new ArrayList<Pattern>();
    private Tuple tuple = new Tuple();

    public ProcessInteractionBuilder replyTo(String outputLine) {
        if (this.tuple.question != null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please append with(String) call");
        }
        this.tuple.question = Pattern.compile(outputLine);
        return this;
    }

    public ProcessInteractionBuilder with(String response) {
        if (this.tuple.question == null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please prepend replyTo(String) call");
        }
        this.tuple.answer = Answer.text(response);
        this.replyMap.put(this.tuple.question, this.tuple.answer);
        this.tuple = new Tuple();
        return this;
    }

    public ProcessInteractionBuilder with(Answer response) {
        if (this.tuple.question == null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please prepend replyTo(String) call");
        }
        this.tuple.answer = response;
        this.replyMap.put(this.tuple.question, this.tuple.answer);
        this.tuple = new Tuple();
        return this;
    }

    public ProcessInteractionBuilder outputs(String pattern) {
        Pattern p = Pattern.compile(pattern);
        this.allowedOutput.add(p);
        return this;
    }

    public ProcessInteractionBuilder errors(String pattern) {
        Pattern p = Pattern.compile(pattern);
        this.errorOutput.add(p);
        return this;
    }

    public ProcessInteraction build() {
        if (this.tuple.question != null) {
            throw new IllegalStateException("Unfinished replyTo().with() sequence, please append with(String) call");
        }
        return new ProcessInteractionImpl(this.replyMap, this.allowedOutput, this.errorOutput);
    }

    private static class ProcessInteractionImpl
    implements ProcessInteraction {
        private final Map<Pattern, Answer> replyMap;
        private final List<Pattern> allowedOutput;
        private final List<Pattern> errorOutput;

        public ProcessInteractionImpl(Map<Pattern, Answer> replyMap, List<Pattern> allowedOutput, List<Pattern> errorOutput) {
            this.replyMap = replyMap;
            this.allowedOutput = allowedOutput;
            this.errorOutput = errorOutput;
        }

        @Override
        public Answer repliesTo(Sentence sentence) {
            for (Map.Entry<Pattern, Answer> entry : this.replyMap.entrySet()) {
                if (!entry.getKey().matcher(sentence).matches()) continue;
                return entry.getValue();
            }
            return Answer.none();
        }

        @Override
        public boolean shouldOutput(Sentence sentence) {
            for (Pattern p : this.allowedOutput) {
                if (!p.matcher(sentence).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldOutputToErr(Sentence sentence) {
            for (Pattern p : this.errorOutput) {
                if (!p.matcher(sentence).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean requiresInputInteraction() {
            return !this.replyMap.isEmpty();
        }
    }

    private static class Tuple {
        Pattern question;
        Answer answer;

        private Tuple() {
        }
    }
}

