/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container;

import org.arquillian.droidium.container.activity.DefaultActivityManagerProvider;
import org.arquillian.droidium.container.api.ActivityManagerProvider;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.container.impl.AndroidApplicationHelper;
import org.arquillian.droidium.container.impl.AndroidApplicationManager;
import org.arquillian.droidium.container.sign.APKSigner;
import org.arquillian.droidium.container.spi.event.AndroidContainerStart;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.container.spi.event.AndroidDeploy;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidUndeploy;
import org.arquillian.droidium.container.utils.AndroidIdentifierGenerator;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.spacelift.process.ProcessExecutor;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class AndroidDeployableContainer
implements DeployableContainer<AndroidContainerConfiguration> {
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidContainerConfiguration> configuration;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidSDK> androidSDK;
    @Inject
    @SuiteScoped
    private InstanceProducer<IdentifierGenerator<FileType>> idGenerator;
    @Inject
    @SuiteScoped
    private InstanceProducer<APKSigner> signer;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidApplicationManager> androidApplicationManager;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    @SuiteScoped
    private InstanceProducer<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Event<AndroidContainerStart> androidContainerStartEvent;
    @Inject
    private Event<AndroidContainerStop> androidContainerStopEvent;
    @Inject
    private Event<AndroidDeploy> deployArchiveEvent;
    @Inject
    private Event<AndroidUndeploy> undeployArchiveEvent;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<ProcessExecutor> executor;

    public Class<AndroidContainerConfiguration> getConfigurationClass() {
        return AndroidContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Android 1.0");
    }

    public void setup(AndroidContainerConfiguration configuration) {
        this.configuration.set((Object)configuration);
        AndroidContainerConfiguration conf = (AndroidContainerConfiguration)this.configuration.get();
        ((ProcessExecutor)this.executor.get()).setEnvironment(conf.getAndroidSystemEnvironmentProperties());
        this.androidSDK.set((Object)new AndroidSDK(conf, (ProcessExecutor)this.executor.get()));
        this.idGenerator.set((Object)new AndroidIdentifierGenerator());
        this.signer.set((Object)new APKSigner((ProcessExecutor)this.executor.get(), (AndroidSDK)this.androidSDK.get(), conf));
        this.androidApplicationHelper.set((Object)new AndroidApplicationHelper((ProcessExecutor)this.executor.get(), (AndroidSDK)this.androidSDK.get()));
        this.androidDeploymentRegister.set((Object)new AndroidDeploymentRegister());
    }

    public void start() throws LifecycleException {
        this.androidContainerStartEvent.fire((Object)new AndroidContainerStart());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.deployArchiveEvent.fire((Object)new AndroidDeploy(archive));
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.undeployArchiveEvent.fire((Object)new AndroidUndeploy(archive));
    }

    public void stop() throws LifecycleException {
        this.androidContainerStopEvent.fire((Object)new AndroidContainerStop());
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Undeployment of a descriptor is not supported.");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of a descriptor is not supported");
    }

    public void onAndroidDeviceReady(@Observes AndroidDeviceReady event) {
        ActivityManagerProvider activityManagerProvider = this.getActivityManagerProvider();
        ((AndroidDevice)this.androidDevice.get()).setActivityManagerProvider(activityManagerProvider);
        this.androidApplicationManager.set((Object)new AndroidApplicationManager((AndroidDevice)this.androidDevice.get(), (ProcessExecutor)this.executor.get(), (AndroidSDK)this.androidSDK.get()));
    }

    public void onBeforeStop(@Observes BeforeStop event) {
        if (event.getDeployableContainer().getConfigurationClass() == AndroidContainerConfiguration.class && ((AndroidContainerConfiguration)this.configuration.get()).getRemoveTmpDir()) {
            DroidiumFileUtils.removeDir(DroidiumFileUtils.getTmpDir());
        }
    }

    private ActivityManagerProvider getActivityManagerProvider() {
        return (ActivityManagerProvider)((ServiceLoader)this.serviceLoader.get()).onlyOne(ActivityManagerProvider.class, DefaultActivityManagerProvider.class);
    }
}

