/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Platform;
import org.arquillian.droidium.container.configuration.SystemImage;
import org.arquillian.droidium.container.configuration.Target;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.process.ProcessExecutor;

public class AndroidSDK {
    public static final String PLATFORMS_FOLDER_NAME = "platforms";
    public static final String PLATFORM_TOOLS_FOLDER_NAME = "platform-tools";
    private static final String BUILD_TOOLS_FOLDER_NAME = "build-tools";
    public static final String SYSTEM_IMAGES_FOLDER_NAME = "system-images";
    public static final String ADD_ONS_FOLDER_NAME = "add-ons";
    private AndroidContainerConfiguration configuration;
    private Platform currentPlatform;
    private final File sdkPath;
    private final File javaPath;

    public AndroidSDK(AndroidContainerConfiguration configuration, ProcessExecutor executor) throws AndroidContainerConfigurationException {
        Validate.notNull(configuration, "AndroidSDK configuration must be provided");
        Validate.notNull(executor, "Process executor for AndroidSDK can no be null object.");
        Validate.isReadableDirectory(configuration.getAndroidHome(), "Unable to read Android SDK from directory " + configuration.getAndroidHome());
        Validate.isReadableDirectory(configuration.getJavaHome(), "Unable to determine JAVA_HOME");
        this.configuration = configuration;
        this.sdkPath = new File(configuration.getAndroidHome());
        this.javaPath = new File(configuration.getJavaHome());
        this.currentPlatform = Platform.getAvailablePlatforms(this.sdkPath).iterator().next();
        if (configuration.getSerialId() == null) {
            Target currentTarget = null;
            String targetId = configuration.getTarget();
            if (targetId != null && !"".equals(targetId)) {
                currentTarget = Target.findMatchingTarget(executor, this.getAndroidPath(), targetId);
                this.currentPlatform = Platform.findPlatformByTarget(this.sdkPath, currentTarget);
                configuration.setTarget(currentTarget.getName());
            } else {
                currentTarget = Target.findMatchingTarget(executor, this.getAndroidPath(), this.currentPlatform.getApiLevel());
                configuration.setTarget(currentTarget.getName());
            }
            SystemImage image = SystemImage.getSystemImageForTarget(this.sdkPath, currentTarget, configuration.getAbi());
            configuration.setAbi(image.getAbi());
        }
        System.out.println("Droidium runtime configuration: ");
        System.out.println(configuration.toString());
    }

    public AndroidContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AndroidContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPathForJavaTool(String tool) {
        File[] possiblePaths;
        for (File candidate : possiblePaths = new File[]{new File(this.javaPath, MessageFormat.format("bin/{0}", tool)), new File(this.javaPath, MessageFormat.format("bin/{0}.exe", tool)), new File(this.javaPath, MessageFormat.format("../bin/{0}", tool)), new File(this.javaPath, MessageFormat.format("../bin/{0}.exe", tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set JAVA_HOME environment property properly and that it points to your Java installation directory. ").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    public String getPathForTool(String tool) {
        File[] possiblePaths;
        for (File candidate : possiblePaths = new File[]{new File(this.sdkPath, MessageFormat.format("tools/{0}", tool)), new File(this.sdkPath, MessageFormat.format("tools/{0}.exe", tool)), new File(this.sdkPath, MessageFormat.format("tools/{0}.bat", tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.exe", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/{1}.bat", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORM_TOOLS_FOLDER_NAME, tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set ANDROID_HOME environment property or androidHome property in arquillian.xml and this location contains all required packages").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getMakeSdCardPath() {
        return this.getPathForTool("mksdcard");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getAaptPath() {
        return this.getBuildTool("aapt");
    }

    public String getAndroidPath() {
        return this.getPathForTool("android");
    }

    public String getPathForFrameworkAidl() throws AndroidContainerConfigurationException {
        return new File(this.currentPlatform.getPath(), "framework.aidl").getAbsolutePath();
    }

    public File getPlatformDirectory() {
        return this.currentPlatform.getPath();
    }

    private String getBuildTool(String tool) {
        File[] possiblePlatformPaths;
        for (File candidate : possiblePlatformPaths = new File[]{new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}", PLATFORMS_FOLDER_NAME, this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.exe", PLATFORMS_FOLDER_NAME, this.getPlatformName(), tool)), new File(this.sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.bat", PLATFORMS_FOLDER_NAME, this.getPlatformName(), tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        File possibleBuildPath = new File(this.sdkPath, BUILD_TOOLS_FOLDER_NAME);
        Object[] dirs = possibleBuildPath.listFiles();
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            for (File candidate : new File[]{new File((File)dir, tool), new File((File)dir, tool + ".exe"), new File((File)dir, tool + ".bat")}) {
                if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
                return candidate.getAbsolutePath();
            }
        }
        throw new RuntimeException("Could not find tool '" + tool + ".");
    }

    private String getPlatformName() {
        return this.currentPlatform.getPath().getName();
    }
}

