/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Target;
import org.arquillian.droidium.container.configuration.Validate;

class Platform {
    private static final Logger log = Logger.getLogger(Platform.class.getName());
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private final String name;
    private final int apiLevel;
    private final File path;

    private Platform(String name, String apiLevel, File path) throws AndroidContainerConfigurationException {
        this.name = name;
        this.path = path;
        try {
            this.apiLevel = Integer.parseInt(apiLevel);
        }
        catch (NumberFormatException e) {
            throw new AndroidContainerConfigurationException("Unable to identify API level of platform, was: " + apiLevel);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public File getPath() {
        return this.path;
    }

    public static Platform findPlatformByTarget(File sdkPath, Target target) {
        for (Platform platform : Platform.getAvailablePlatforms(sdkPath)) {
            if (platform.getApiLevel() != target.getApiLevel()) continue;
            return platform;
        }
        throw new AndroidContainerConfigurationException(String.format("Platform you are trying to find for target '%s' is unknown.", target));
    }

    public static List<Platform> getAvailablePlatforms(File sdkPath) throws AndroidContainerConfigurationException {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        List<File> platformDirectories = Platform.getPlatformDirectories(sdkPath);
        for (File pDir : platformDirectories) {
            File propFile = new File(pDir, SOURCE_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new AndroidContainerConfigurationException("Unable to read platform directory details from its configuration file " + propFile.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            Platform p = new Platform(platform, apiLevel, pDir);
            platforms.add(p);
            log.log(Level.FINE, "Found available platform {0}", p);
        }
        Collections.sort(platforms, new Comparator<Platform>(){

            @Override
            public int compare(Platform o1, Platform o2) {
                Integer current = o1.apiLevel;
                Integer other = o2.apiLevel;
                return other.compareTo(current);
            }
        });
        if (platforms.size() == 0) {
            throw new AndroidContainerConfigurationException("There are not any available platforms found on your system!");
        }
        return platforms;
    }

    private static List<File> getPlatformDirectories(File sdkPath) {
        File[] platformDirectories;
        ArrayList<File> foundPlatformDirs = new ArrayList<File>();
        File platformsDirectory = new File(sdkPath, "platforms");
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        for (File file : platformDirectories = platformsDirectory.listFiles()) {
            if (!file.isDirectory() || !file.getName().startsWith("android-")) continue;
            foundPlatformDirs.add(file);
        }
        return foundPlatformDirs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Platform: ");
        sb.append(this.name).append("/API level ").append(this.apiLevel).append(" at ").append(this.path);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.apiLevel;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Platform other = (Platform)obj;
        if (this.apiLevel != other.apiLevel) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

