/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Target;

class SystemImage {
    private static final Logger log = Logger.getLogger(SystemImage.class.getName());
    private static final String RAMDISK_NAME = "ramdisk.img";
    private final String name;
    private final String abi;

    private SystemImage(String name, String abi) {
        this.name = name;
        this.abi = abi;
    }

    public static SystemImage getSystemImageForTarget(File sdkPath, Target target, String abi) throws AndroidContainerConfigurationException {
        List<SystemImage> images = SystemImage.getSystemImagesForTarget(sdkPath, target);
        if (abi == null || "".equals(abi)) {
            if (images.size() == 1) {
                return images.iterator().next();
            }
            return SystemImage.guessAbi(images, target);
        }
        for (SystemImage si : images) {
            if (!(abi.contains("/") ? abi.equals(si.getAbi()) : ("default/" + abi).equals(si.getAbi()))) continue;
            return si;
        }
        if (images.size() == 1) {
            log.log(Level.WARNING, "ABI property from configuration ({0}) does not match only available image {1}. Arquillian configuration will be ignored.", new Object[]{abi, images.iterator().next().getAbi()});
            return images.iterator().next();
        }
        return SystemImage.guessAbi(images, target);
    }

    private static List<SystemImage> getSystemImagesForTarget(File sdkPath, Target target) throws AndroidContainerConfigurationException {
        File dir = null;
        if (target.isGoogleAddon()) {
            dir = new File(new File(sdkPath, "add-ons"), target.getImagesSubdirectory());
            if (!dir.exists()) {
                List<File> addons = FileUtils.listDirectories(new File(sdkPath, "add-ons"));
                String addonName = target.getImagesSubdirectory();
                if (addonName.endsWith("/images")) {
                    addonName = addonName.substring(0, addonName.length() - "/images".length());
                }
                for (File addon : addons) {
                    if (!addon.getName().startsWith(addonName) || !new File(addon, "images").exists()) continue;
                    dir = addon;
                    break;
                }
            }
        } else {
            dir = new File(new File(sdkPath, "system-images"), target.getImagesSubdirectory());
        }
        if (!dir.exists()) {
            throw new AndroidContainerConfigurationException("Unable to find out images for target: " + target + ", directory: " + dir + " does not exist.");
        }
        if (target.isGoogleAddon() && target.getApiLevel() == 10 && new File(dir, RAMDISK_NAME).exists()) {
            return Collections.singletonList(new SystemImage(target.getName(), "armeabi"));
        }
        ArrayList<SystemImage> availableImages = new ArrayList<SystemImage>();
        List<File> directories = FileUtils.listDirectories(dir);
        for (File imageCandidate : directories) {
            if (!new File(imageCandidate, RAMDISK_NAME).exists()) continue;
            File parentDir = imageCandidate.getParentFile();
            if (dir.equals(parentDir) || parentDir != null && "images".equals(parentDir.getName())) {
                availableImages.add(new SystemImage(target.getName(), "default/" + imageCandidate.getName()));
                continue;
            }
            if (parentDir != null) {
                availableImages.add(new SystemImage(target.getName(), parentDir.getName() + "/" + imageCandidate.getName()));
                continue;
            }
            throw new AndroidContainerConfigurationException("Unable to figure out what images are available for target: " + target);
        }
        if (availableImages.isEmpty()) {
            throw new AndroidContainerConfigurationException("No system images were available for target: " + target);
        }
        Collections.sort(availableImages, new Comparator<SystemImage>(){

            @Override
            public int compare(SystemImage o1, SystemImage o2) {
                return o2.getAbi().compareTo(o1.getAbi());
            }
        });
        return availableImages;
    }

    private static SystemImage guessAbi(List<SystemImage> images, Target target) {
        StringBuilder sb = new StringBuilder("There were more ABIs for target \"").append(target).append("\" available: ");
        String delimiter = "";
        for (SystemImage si : images) {
            sb.append(delimiter).append(si.getAbi());
            delimiter = ", ";
        }
        sb.append(". Please use \"abi\" configuration property to select ABI. At this moment, Droidium will autoselect ").append(images.iterator().next().getAbi()).append(".");
        log.log(Level.WARNING, sb.toString());
        return images.iterator().next();
    }

    public String getName() {
        return this.name;
    }

    public String getAbi() {
        return this.abi;
    }

    public String toString() {
        return "image: " + this.name + ", abi: " + this.abi;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abi == null ? 0 : this.abi.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemImage other = (SystemImage)obj;
        if (this.abi == null ? other.abi != null : !this.abi.equals(other.abi)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private static final class FileUtils {
        private FileUtils() {
        }

        static List<File> listDirectories(File rootDirectory) {
            ArrayList<File> dirs = new ArrayList<File>();
            FileUtils.listDirectories(rootDirectory, dirs);
            return dirs;
        }

        static void listDirectories(File rootDirectory, List<File> acc) {
            if (rootDirectory == null || !rootDirectory.isDirectory()) {
                return;
            }
            acc.add(rootDirectory);
            for (File candidate : rootDirectory.listFiles()) {
                FileUtils.listDirectories(candidate, acc);
            }
        }
    }
}

