/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessExecutor;

class Target {
    private static final Logger log = Logger.getLogger(Target.class.getName());
    protected static final Pattern ANDROID_LEVEL_PATTERN = Pattern.compile("[0-9]+");
    protected static final Pattern ANDROID_PATTERN = Pattern.compile("android-([0-9]+)");
    protected static final Pattern GOOGLE_ADDON_PATTERN = Pattern.compile("Google Inc.:([\\w ]+):([0-9]+)");
    private final String name;
    private final boolean isGoogleAddon;
    private final String imagesSubdirectory;
    private final int apiLevel;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Target(String name) throws AndroidContainerConfigurationException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Android target was null");
        }
        Matcher m = null;
        m = ANDROID_LEVEL_PATTERN.matcher(name);
        if (m.matches()) {
            this.name = "android-" + name;
            this.apiLevel = Integer.parseInt(m.group());
            this.isGoogleAddon = false;
            this.imagesSubdirectory = "android-" + this.apiLevel;
            return;
        } else {
            m = ANDROID_PATTERN.matcher(name);
            if (m.matches()) {
                this.name = name;
                this.apiLevel = Integer.parseInt(m.group(1));
                this.isGoogleAddon = false;
                this.imagesSubdirectory = "android-" + this.apiLevel;
                return;
            } else {
                m = GOOGLE_ADDON_PATTERN.matcher(name);
                if (!m.matches()) throw new AndroidContainerConfigurationException("Invalid Android target name: " + name);
                this.name = name;
                this.apiLevel = Integer.parseInt(m.group(2));
                this.isGoogleAddon = true;
                String type = m.group(1);
                if (type.startsWith("Google APIs") && type.contains("x86")) {
                    this.imagesSubdirectory = "addon-google_apis_x86-google-" + this.apiLevel + "/images";
                    return;
                } else if (type.startsWith("Google APIs")) {
                    this.imagesSubdirectory = "addon-google_apis-google-" + this.apiLevel + "/images";
                    return;
                } else if (type.startsWith("Google TV")) {
                    this.imagesSubdirectory = "addon-google_tv_addon-google-" + this.apiLevel + "/images";
                    return;
                } else {
                    if (!type.startsWith("Glass")) throw new AndroidContainerConfigurationException("Invalid Android target name: " + name);
                    throw new AndroidContainerConfigurationException("Glass does not represent a valid Droidium target, no emulator is available: " + name);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isGoogleAddon() {
        return this.isGoogleAddon;
    }

    public String getImagesSubdirectory() {
        return this.imagesSubdirectory;
    }

    public int getApiLevel() {
        return this.apiLevel;
    }

    public String toString() {
        return this.name;
    }

    public static Target findMatchingTarget(ProcessExecutor executor, String androidToolPath, int apiLevel) {
        return Target.findMatchingTarget(executor, androidToolPath, String.valueOf(apiLevel));
    }

    public static Target findMatchingTarget(ProcessExecutor executor, String androidToolPath, String targetLabel) throws AndroidContainerConfigurationException {
        Target t = new Target(targetLabel);
        List<Target> availableTargets = Target.getAvailableTargets(executor, androidToolPath);
        if (availableTargets.contains(t)) {
            return t;
        }
        throw new AndroidContainerConfigurationException(String.format("There is not any target with target name '%s'", targetLabel));
    }

    public static List<Target> getAvailableTargets(ProcessExecutor executor, String androidToolPath) throws AndroidContainerConfigurationException {
        List targetsOutput = executor.execute(new CommandBuilder().add((CharSequence)androidToolPath).add((CharSequence)"list").add((CharSequence)"target").add((CharSequence)"-c").build()).getOutput();
        Collections.sort(targetsOutput);
        Collections.reverse(targetsOutput);
        ArrayList<Target> targets = new ArrayList<Target>();
        for (String target : targetsOutput) {
            try {
                if (target == null || "".equals(target.trim())) continue;
                targets.add(new Target(target.trim()));
            }
            catch (AndroidContainerConfigurationException e) {
                log.log(Level.FINE, "Unknown target \"{0}\", Droidium will ignore it", target);
            }
        }
        if (targets.size() == 0) {
            throw new AndroidContainerConfigurationException("There are not any available targets found on your system!");
        }
        return targets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.apiLevel;
        result = 31 * result + (this.imagesSubdirectory == null ? 0 : this.imagesSubdirectory.hashCode());
        result = 31 * result + (this.isGoogleAddon ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        if (this.apiLevel != other.apiLevel) {
            return false;
        }
        if (this.imagesSubdirectory == null ? other.imagesSubdirectory != null : !this.imagesSubdirectory.equals(other.imagesSubdirectory)) {
            return false;
        }
        if (this.isGoogleAddon != other.isGoogleAddon) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

