/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.impl.AndroidEmulator;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.container.spi.event.AndroidEmulatorShuttedDown;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.spacelift.process.ProcessExecution;
import org.arquillian.spacelift.process.ProcessExecutionException;
import org.arquillian.spacelift.process.ProcessExecutor;
import org.arquillian.spacelift.process.impl.CountDownWatch;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidEmulatorShutdown {
    private static final Logger logger = Logger.getLogger(AndroidEmulatorShutdown.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<AndroidEmulator> androidEmulator;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Event<AndroidEmulatorShuttedDown> androidEmulatorShuttedDown;
    @Inject
    private Event<AndroidVirtualDeviceDelete> androidVirtualDeviceDelete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownEmulator(@Observes AndroidContainerStop event) throws AndroidExecutionException {
        AndroidEmulator emulator = (AndroidEmulator)this.androidEmulator.get();
        AndroidDevice device = (AndroidDevice)this.androidDevice.get();
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        if (emulator != null && device.isEmulator()) {
            logger.log(Level.INFO, "Stopping Android emulator of AVD name {0}.", configuration.getAvdName());
            ProcessExecutor executor = (ProcessExecutor)this.executor.get();
            ProcessExecution processExecution = emulator.getProcessExecution();
            CountDownWatch countdown = new CountDownWatch(configuration.getEmulatorShutdownTimeoutInSeconds(), TimeUnit.SECONDS);
            logger.info("Waiting " + countdown.timeout() + " seconds for emulator " + device.getAvdName() + " to be disconnected and shutdown.");
            try {
                DeviceDisconnectDiscovery listener = new DeviceDisconnectDiscovery(device);
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
                this.stopEmulator(processExecution, executor, device, countdown);
                this.waitUntilShutDownIsComplete(device, listener, executor, countdown);
                AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
                if (configuration.isAVDGenerated()) {
                    this.androidVirtualDeviceDelete.fire((Object)new AndroidVirtualDeviceDelete());
                }
                this.androidEmulatorShuttedDown.fire((Object)new AndroidEmulatorShuttedDown(device));
            }
            finally {
                executor.removeShutdownHook(processExecution);
            }
        }
    }

    private void waitUntilShutDownIsComplete(AndroidDevice device, final DeviceDisconnectDiscovery listener, ProcessExecutor executor, CountDownWatch countdown) throws AndroidExecutionException {
        boolean isOffline = executor.scheduleUntilTrue((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return listener.isOffline();
            }
        }, countdown.timeLeft(), countdown.getTimeUnit().convert(1L, TimeUnit.SECONDS), countdown.getTimeUnit());
        if (!isOffline) {
            throw new AndroidExecutionException("Unable to disconnect AVD device {0} in given timeout {1} seconds", new Object[]{device.getAvdName(), countdown.timeout()});
        }
        logger.info("Device " + device.getAvdName() + " on port " + device.getConsolePort() + " was disconnected in " + countdown.timeElapsed() + " seconds.");
    }

    private Boolean stopEmulator(final ProcessExecution p, ProcessExecutor executor, AndroidDevice device, CountDownWatch countdown) throws AndroidExecutionException {
        int devicePort = this.extractPortFromDevice(device);
        if (devicePort == -1) {
            logger.severe("Unable to retrieve port to stop emulator " + device.getSerialNumber() + ".");
            return false;
        }
        logger.info("Stopping emulator " + device.getSerialNumber() + " via port " + devicePort + ".");
        try {
            Boolean stopped = (Boolean)executor.submit(this.sendEmulatorCommand(devicePort, "kill")).get(countdown.timeLeft(), countdown.getTimeUnit());
            Boolean isFinished = executor.scheduleUntilTrue((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return p.isFinished();
                }
            }, countdown.timeLeft(), 5L, TimeUnit.SECONDS);
            return stopped != false && isFinished != false;
        }
        catch (TimeoutException e) {
            p.terminate();
            logger.warning("Emulator process was forcibly destroyed, " + countdown.timeLeft() + " seconds remaining to dispose the device");
            throw new AndroidExecutionException((Throwable)e, "Unable to stop emulator {0}", new Object[]{device.getAvdName()});
        }
        catch (ExecutionException e) {
            p.terminate();
            throw new AndroidExecutionException((Throwable)e, "Unable to stop emulator {0}", new Object[]{device.getAvdName()});
        }
        catch (InterruptedException e) {
            p.terminate();
            throw new AndroidExecutionException((Throwable)e, "Unable to stop emulator {0}", new Object[]{device.getAvdName()});
        }
        catch (ProcessExecutionException e) {
            p.terminate();
            throw new AndroidExecutionException((Throwable)e, "Unable to stop emulator {0}", new Object[]{device.getAvdName()});
        }
    }

    private int extractPortFromDevice(AndroidDevice device) {
        String portStr = device.getSerialNumber().substring(device.getSerialNumber().lastIndexOf("-") + 1);
        if (portStr != null && portStr.length() > 0) {
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private Callable<Boolean> sendEmulatorCommand(final int port, final String command) {
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws IOException {
                Socket socket = null;
                BufferedReader in = null;
                PrintWriter out = null;
                try {
                    socket = new Socket("127.0.0.1", port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String telnetOutputString = null;
                    while ((telnetOutputString = in.readLine()) != null && !telnetOutputString.equals("OK")) {
                    }
                    out.write(command);
                    out.write("\n");
                    out.flush();
                }
                finally {
                    try {
                        out.close();
                        in.close();
                        socket.close();
                    }
                    catch (Exception e) {}
                }
                return true;
            }
        };
    }

    private static class DeviceDisconnectDiscovery
    implements AndroidDebugBridge.IDeviceChangeListener {
        private boolean offline;
        private final AndroidDevice connectedDevice;

        public DeviceDisconnectDiscovery(AndroidDevice connectedDevice) {
            this.connectedDevice = connectedDevice;
        }

        public void deviceChanged(IDevice device, int changeMask) {
        }

        public void deviceDisconnected(IDevice device) {
            if (device.getAvdName().equals(this.connectedDevice.getAvdName())) {
                this.offline = true;
            }
            logger.fine("Discovered an emulator device id=" + device.getSerialNumber() + " disconnected from ADB bus");
        }

        public boolean isOffline() {
            return this.offline;
        }

        public void deviceConnected(IDevice device) {
        }
    }
}

