/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.sign;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.sign.APKSignerException;
import org.arquillian.droidium.container.sign.KeyStoreCreator;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessExecutor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class APKSigner {
    private static final Logger logger = Logger.getLogger(APKSigner.class.getName());
    private final AndroidSDK sdk;
    private final AndroidContainerConfiguration configuration;
    private final ProcessExecutor executor;

    public APKSigner(ProcessExecutor executor, AndroidSDK sdk, AndroidContainerConfiguration configuration) throws IllegalArgumentException {
        Validate.notNull(executor, "Process executor to set can not be a null object!");
        Validate.notNull(sdk, "Android SDK to set can not be a null object!");
        Validate.notNull(configuration, "Droidium configuration to set can not be a null object!");
        this.executor = executor;
        this.sdk = sdk;
        this.configuration = configuration;
    }

    public File sign(File toSign, File signed) {
        this.checkKeyStore();
        Command jarSignerCommand = new CommandBuilder().add((CharSequence)this.sdk.getPathForJavaTool("jarsigner")).add((CharSequence)"-sigalg").add((CharSequence)"MD5withRSA").add((CharSequence)"-digestalg").add((CharSequence)"SHA1").add((CharSequence)"-signedjar").add((CharSequence)signed.getAbsolutePath()).add((CharSequence)"-storepass").add((CharSequence)this.configuration.getStorepass()).add((CharSequence)"-keystore").add((CharSequence)new File(this.configuration.getKeystore()).getAbsolutePath()).add((CharSequence)toSign.getAbsolutePath()).add((CharSequence)this.configuration.getAlias()).build();
        logger.log(Level.FINE, jarSignerCommand.toString());
        try {
            this.executor.execute(jarSignerCommand);
        }
        catch (AndroidExecutionException e) {
            throw new APKSignerException("Unable to sign package, signing process failed.", e);
        }
        return signed;
    }

    public File resign(File toResign) {
        Validate.notNull(toResign, "File to resign can not be a null object!");
        Archive apk = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)toResign);
        apk.delete("META-INF");
        File toSign = new File(DroidiumFileUtils.getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        DroidiumFileUtils.export(apk, toSign);
        return this.sign(toSign, new File(DroidiumFileUtils.getTmpDir(), DroidiumFileUtils.getRandomAPKFileName()));
    }

    private void checkKeyStore() {
        KeyStoreCreator keyStoreCreator = new KeyStoreCreator(this.executor, this.sdk, this.configuration);
        if (!keyStoreCreator.keyStoreExists(new File(this.configuration.getKeystore()))) {
            File defaultKeyStore = new File(this.getDefaultKeyStorePath());
            if (!keyStoreCreator.keyStoreExists(defaultKeyStore)) {
                keyStoreCreator.createKeyStore(defaultKeyStore);
            }
            this.configuration.setKeystore(defaultKeyStore.getAbsolutePath());
        }
    }

    private String getDefaultKeyStorePath() {
        String separator = System.getProperty("file.separator");
        return this.configuration.getAndroidSdkHome() + ".android" + separator + "debug.keystore";
    }
}

