/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.sign;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessExecutor;

public final class KeyStoreCreator {
    private static final Logger logger = Logger.getLogger(KeyStoreCreator.class.getName());
    private final AndroidSDK sdk;
    private final AndroidContainerConfiguration configuration;
    private final ProcessExecutor executor;

    public KeyStoreCreator(ProcessExecutor executor, AndroidSDK sdk, AndroidContainerConfiguration configuration) {
        Validate.notNull(configuration, "Process Executor for key store creator must not be a null object!");
        Validate.notNull(sdk, "Android sdk for key store creator can not be a null object!");
        Validate.notNull(configuration, "Droidium configuration for key store creator can not be a null object!");
        this.executor = executor;
        this.sdk = sdk;
        this.configuration = configuration;
    }

    public boolean keyStoreExists(File keyStore) {
        try {
            Validate.isReadable(keyStore, "You must provide a valid path to keystore for signing of APK files: '" + keyStore.getAbsolutePath() + ".");
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public void createKeyStore(File keyStoreToCreate) {
        Command createKeyStoreCommand = new CommandBuilder().add((CharSequence)this.sdk.getPathForJavaTool("keytool")).add((CharSequence)"-genkey").add((CharSequence)"-v").add((CharSequence)"-keystore").add((CharSequence)keyStoreToCreate.getAbsolutePath()).add((CharSequence)"-storepass").add((CharSequence)this.configuration.getStorepass()).add((CharSequence)"-alias").add((CharSequence)this.configuration.getAlias()).add((CharSequence)"-keypass").add((CharSequence)this.configuration.getKeypass()).add((CharSequence)"-dname").add((CharSequence)"CN=Android,O=Android,C=US").add((CharSequence)"-storetype").add((CharSequence)"JKS").add((CharSequence)"-sigalg").add((CharSequence)this.configuration.getSigalg()).add((CharSequence)"-keyalg").add((CharSequence)this.configuration.getKeyalg()).build();
        logger.log(Level.INFO, createKeyStoreCommand.toString());
        this.executor.execute(createKeyStoreCommand);
    }
}

