/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container;

import org.arquillian.droidium.container.activity.DefaultActivityManager;
import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.spi.event.AndroidContainerStart;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.container.spi.event.AndroidDeploy;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidUnDeploy;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class AndroidDeployableContainer
implements DeployableContainer<AndroidContainerConfiguration> {
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<AndroidContainerStart> androidContainerStart;
    @Inject
    private Event<AndroidContainerStop> androidContainerStop;
    @Inject
    private Event<AndroidDeploy> androidDeploy;
    @Inject
    private Event<AndroidUnDeploy> androidUnDeploy;

    public Class<AndroidContainerConfiguration> getConfigurationClass() {
        return AndroidContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Android 1.0");
    }

    public void setup(AndroidContainerConfiguration configuration) {
        this.configuration.set((Object)configuration);
        ((AndroidSDK)this.androidSDK.get()).setupWith((AndroidContainerConfiguration)this.configuration.get());
    }

    public void start() throws LifecycleException {
        this.androidContainerStart.fire((Object)new AndroidContainerStart());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.androidDeploy.fire((Object)new AndroidDeploy(archive));
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.androidUnDeploy.fire((Object)new AndroidUnDeploy(archive));
    }

    public void stop() throws LifecycleException {
        this.androidContainerStop.fire((Object)new AndroidContainerStop());
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Undeployment of a descriptor is not supported.");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of a descriptor is not supported");
    }

    public void onAndroidDeviceReady(@Observes AndroidDeviceReady event) {
        ActivityManager activityManager = (ActivityManager)((ServiceLoader)this.serviceLoader.get()).onlyOne(ActivityManager.class, DefaultActivityManager.class);
        if (activityManager instanceof DefaultActivityManager) {
            ((AndroidDevice)this.androidDevice.get()).setActivityManager((ActivityManager)new DefaultActivityManager((AndroidDevice)this.androidDevice.get()));
        }
    }
}

