/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Validate;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class AndroidContainerConfiguration
implements ContainerConfiguration {
    private String fileSeparator = System.getProperty("file.separator");
    private static final Logger logger = Logger.getLogger(AndroidContainerConfiguration.class.getName());
    private String serialId;
    private String avdName;
    private String emulatorOptions;
    private String sdSize = "128M";
    private String sdCard;
    private String sdCardLabel;
    private boolean generateSDCard;
    private String abi;
    private long emulatorBootupTimeoutInSeconds = 600L;
    private long emulatorShutdownTimeoutInSeconds = 60L;
    private boolean avdGenerated;
    private String consolePort;
    private String adbPort;
    private int droneHostPort = 14444;
    private int droneGuestPort = 8080;
    private String logLevel = "W";
    private String logType = "disable";
    private String logFilePath = "target" + this.fileSeparator + "logcat.log";
    private String logPackageWhitelist;
    private String logPackageBlacklist;
    private boolean logSerialId;
    private String target;

    public String getAvdName() {
        return this.avdName;
    }

    public void setAvdName(String avdName) {
        this.avdName = avdName;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getEmulatorOptions() {
        return this.emulatorOptions;
    }

    public void setEmulatorOptions(String emulatorOptions) {
        this.emulatorOptions = emulatorOptions;
    }

    public long getEmulatorBootupTimeoutInSeconds() {
        return this.emulatorBootupTimeoutInSeconds;
    }

    public void setEmulatorBootupTimeoutInSeconds(long emulatorBootupTimeoutInSeconds) {
        this.emulatorBootupTimeoutInSeconds = emulatorBootupTimeoutInSeconds;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getSdSize() {
        return this.sdSize;
    }

    public void setSdSize(String sdSize) {
        this.sdSize = sdSize;
    }

    public String getSdCard() {
        return this.sdCard;
    }

    public String getSdCardLabel() {
        return this.sdCardLabel;
    }

    public void setSdCardLabel(String sdCardLabel) {
        this.sdCardLabel = sdCardLabel;
    }

    public boolean getGenerateSDCard() {
        return this.generateSDCard;
    }

    public void setGenerateSDCard(boolean generate) {
        this.generateSDCard = generate;
    }

    public void setSdCard(String sdCard) {
        this.sdCard = sdCard;
    }

    public long getEmulatorShutdownTimeoutInSeconds() {
        return this.emulatorShutdownTimeoutInSeconds;
    }

    public void setEmulatorShutdownTimeoutInSeconds(long emulatorShutdownTimeoutInSeconds) {
        this.emulatorShutdownTimeoutInSeconds = emulatorShutdownTimeoutInSeconds;
    }

    public String getAbi() {
        return this.abi;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public boolean isAVDGenerated() {
        return this.avdGenerated;
    }

    public void setAvdGenerated(boolean generated) {
        this.avdGenerated = generated;
    }

    public boolean getAvdGenerated() {
        return this.avdGenerated;
    }

    public String getConsolePort() {
        return this.consolePort;
    }

    public void setConsolePort(String consolePort) {
        this.consolePort = consolePort;
    }

    public String getAdbPort() {
        return this.adbPort;
    }

    public void setAdbPort(String adbPort) {
        this.adbPort = adbPort;
    }

    public int getDroneHostPort() {
        return this.droneHostPort;
    }

    public int getDroneGuestPort() {
        return this.droneGuestPort;
    }

    public void setDroneHostPort(int droneHostPort) {
        this.droneHostPort = droneHostPort;
    }

    public void setDroneGuestPort(int droneGuestPort) {
        this.droneGuestPort = droneGuestPort;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getLogPackageWhitelist() {
        return this.logPackageWhitelist;
    }

    public void setLogPackageWhitelist(String logPackageWhitelist) {
        this.logPackageWhitelist = logPackageWhitelist;
    }

    public String getLogPackageBlacklist() {
        return this.logPackageBlacklist;
    }

    public void setLogPackageBlacklist(String logPackageBlacklist) {
        this.logPackageBlacklist = logPackageBlacklist;
    }

    public boolean isLogFilteringEnabled() {
        return this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") || this.logPackageBlacklist != null && !this.logPackageBlacklist.equals("");
    }

    public boolean isLogSerialId() {
        return this.logSerialId;
    }

    public void setLogSerialId(boolean logSerialId) {
        this.logSerialId = logSerialId;
    }

    public void validate() throws AndroidContainerConfigurationException {
        if (this.avdName != null && this.serialId != null) {
            logger.warning("Both \"avdName\" and \"serialId\" properties are defined, the device specified by \"serialId\" will get priority if connected.");
        }
        if (this.consolePort != null) {
            Validate.isConsolePortValid(this.consolePort);
        }
        if (this.adbPort != null) {
            Validate.isAdbPortValid(this.adbPort);
        }
        if (this.sdCard != null) {
            Validate.sdCardFileName(this.sdCard, "File name (or path) of SD card to use '" + this.sdCard + "' is not valid. Check it is under existing and writable directory does have '.img' suffix.");
        }
        if (this.sdCardLabel != null) {
            Validate.notNullOrEmpty(this.sdCardLabel, "SD card label can not be the empty string");
        }
        if (this.sdSize != null) {
            Validate.sdSize(this.sdSize, "Check you did specify your sdSize property in arquillian.xml properly.");
        }
        if (this.droneHostPort != 14444) {
            Validate.isPortValid(this.droneHostPort);
        }
        if (this.droneGuestPort != 8080) {
            Validate.isPortValid(this.droneGuestPort);
        }
        if (this.logPackageWhitelist != null && !this.logPackageWhitelist.equals("") && this.logPackageBlacklist == null) {
            this.logPackageBlacklist = "*";
            logger.warning("\"logPackageBlacklist\" isn't defined, but \"logPackageWhitelist\" is. Assuming \"*\" as a value for \"logPackageBlacklist\"!");
        }
        if (this.emulatorBootupTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator bootup timeout has to be bigger then 0.");
        }
        if (this.emulatorShutdownTimeoutInSeconds <= 0L) {
            throw new AndroidContainerConfigurationException("Emulator shutdown timeout has to be bigger then 0.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "avdName", this.avdName));
        sb.append(String.format("%-40s %s\n", "serialId", this.serialId));
        sb.append(String.format("%-40s %s\n", "target", this.target));
        sb.append(String.format("%-40s %s\n", "abi", this.abi));
        sb.append(String.format("%-40s %s\n", "consolePort", this.consolePort));
        sb.append(String.format("%-40s %s\n", "adbPort", this.adbPort));
        sb.append(String.format("%-40s %s\n", "emulatorBootupTimeoutInSeconds", this.emulatorBootupTimeoutInSeconds));
        sb.append(String.format("%-40s %s\n", "emulatorShutdownTimeoutInSeconds", this.emulatorShutdownTimeoutInSeconds));
        sb.append(String.format("%-40s %s\n", "emulatorOptions", this.emulatorOptions));
        sb.append(String.format("%-40s %s\n", "sdCard", this.sdCard));
        sb.append(String.format("%-40s %s\n", "sdSize", this.sdSize));
        sb.append(String.format("%-40s %s\n", "generateSDCard", this.generateSDCard));
        sb.append(String.format("%-40s %s\n", "logLevel", this.logLevel));
        sb.append(String.format("%-40s %s\n", "logType", this.logType));
        sb.append(String.format("%-40s %s\n", "logFilePath", this.logFilePath));
        sb.append(String.format("%-40s %s\n", "logPackageWhitelist", this.logPackageWhitelist));
        sb.append(String.format("%-40s %s\n", "logPackageBlacklist", this.logPackageBlacklist));
        return sb.toString();
    }
}

