/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Platform;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.configuration.target.TargetParser;
import org.arquillian.droidium.container.configuration.target.TargetPicker;
import org.arquillian.droidium.container.configuration.target.TargetRegistry;
import org.arquillian.droidium.platform.impl.DroidiumPlatformConfiguration;

public final class AndroidSDK {
    public static final String PLATFORMS_FOLDER_NAME = "platforms";
    public static final String PLATFORM_TOOLS_FOLDER_NAME = "platform-tools";
    private static final String BUILD_TOOLS_FOLDER_NAME = "build-tools";
    public static final String SYSTEM_IMAGES_FOLDER_NAME = "system-images";
    public static final String ADD_ONS_FOLDER_NAME = "add-ons";
    private final TargetRegistry targetRegistry;
    private final DroidiumPlatformConfiguration platformConfiguration;
    private AndroidContainerConfiguration containerConfiguration;
    private Platform currentPlatform;

    public AndroidSDK(DroidiumPlatformConfiguration platformConfiguration) {
        Validate.notNull(platformConfiguration, "Droidium platform configuration can not be a null object!");
        this.platformConfiguration = platformConfiguration;
        this.currentPlatform = Platform.getAvailablePlatforms(platformConfiguration.getAndroidHome()).iterator().next();
        this.targetRegistry = new TargetRegistry();
    }

    public void setupWith(AndroidContainerConfiguration containerConfiguration) {
        Validate.notNull(containerConfiguration, "Container configuration must be provided");
        this.containerConfiguration = containerConfiguration;
        if (this.containerConfiguration.getSerialId() != null) {
            return;
        }
        this.initializeTargetRegistry();
        new TargetPicker(this.targetRegistry, this.getAndroidContainerConfiguration()).pick();
        System.out.println("Droidium runtime configuration: ");
        System.out.println(this.getAndroidContainerConfiguration().toString());
    }

    private void initializeTargetRegistry() {
        if (this.targetRegistry.getTargets().size() == 0) {
            this.targetRegistry.addTargets(new TargetParser(this, this.getPlatformConfiguration()).parse());
        }
    }

    public AndroidContainerConfiguration getAndroidContainerConfiguration() {
        if (this.containerConfiguration == null) {
            throw new IllegalStateException("You have not called AndroidSDK.setupWith(AndroidContainerConfiguration) method");
        }
        return this.containerConfiguration;
    }

    public DroidiumPlatformConfiguration getPlatformConfiguration() {
        return this.platformConfiguration;
    }

    public String getPathForJavaTool(String tool) {
        File[] possiblePaths;
        File javaPath = new File(this.platformConfiguration.getJavaHome());
        for (File candidate : possiblePaths = new File[]{new File(javaPath, MessageFormat.format("bin/{0}", tool)), new File(javaPath, MessageFormat.format("bin/{0}.exe", tool)), new File(javaPath, MessageFormat.format("../bin/{0}", tool)), new File(javaPath, MessageFormat.format("../bin/{0}.exe", tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set JAVA_HOME environment property properly and that it points to your Java installation directory. ").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    public String getPathForTool(String tool) {
        File[] possiblePaths;
        File sdkPath = new File(this.getPlatformConfiguration().getAndroidHome());
        String platformDirName = this.getPlatformDirectory().getName();
        for (File candidate : possiblePaths = new File[]{new File(sdkPath, MessageFormat.format("tools/{0}", tool)), new File(sdkPath, MessageFormat.format("tools/{0}.exe", tool)), new File(sdkPath, MessageFormat.format("tools/{0}.bat", tool)), new File(sdkPath, MessageFormat.format("{0}/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}.exe", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/{1}.bat", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", PLATFORMS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}.exe", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/tools/lib/{1}.bat", platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}.exe", PLATFORM_TOOLS_FOLDER_NAME, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}.bat", PLATFORM_TOOLS_FOLDER_NAME, tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        StringBuilder exception = new StringBuilder("Could not find tool '").append(tool).append("'. Please ensure you've set ANDROID_HOME environment property or androidHome property in arquillian.xml and this location contains all required packages").append("Searching at locations: ");
        String delimiter = "";
        for (File candidate : possiblePaths) {
            exception.append(delimiter).append(candidate.getAbsolutePath());
            delimiter = ", ";
        }
        throw new RuntimeException(exception.toString());
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getMakeSdCardPath() {
        return this.getPathForTool("mksdcard");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getAaptPath() {
        return this.getBuildTool("aapt");
    }

    public String getAndroidPath() {
        return this.getPathForTool("android");
    }

    public String getPathForFrameworkAidl() throws AndroidContainerConfigurationException {
        return new File(this.currentPlatform.getPath(), "framework.aidl").getAbsolutePath();
    }

    public File getPlatformDirectory() {
        return this.currentPlatform.getPath();
    }

    private String getBuildTool(String tool) {
        File[] possiblePlatformPaths;
        File sdkPath = new File(this.getPlatformConfiguration().getAndroidHome());
        String platformDirName = this.getPlatformDirectory().getName();
        for (File candidate : possiblePlatformPaths = new File[]{new File(sdkPath, MessageFormat.format("{0}/{1}/tools/{2}", PLATFORMS_FOLDER_NAME, platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.exe", PLATFORMS_FOLDER_NAME, platformDirName, tool)), new File(sdkPath, MessageFormat.format("{0}/{1}/tools/{2}.bat", PLATFORMS_FOLDER_NAME, platformDirName, tool))}) {
            if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
            return candidate.getAbsolutePath();
        }
        File possibleBuildPath = new File(sdkPath, BUILD_TOOLS_FOLDER_NAME);
        Object[] dirs = possibleBuildPath.listFiles();
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            for (File candidate : new File[]{new File((File)dir, tool), new File((File)dir, tool + ".exe"), new File((File)dir, tool + ".bat")}) {
                if (!candidate.exists() || !candidate.isFile() || !candidate.canExecute()) continue;
                return candidate.getAbsolutePath();
            }
        }
        throw new RuntimeException("Could not find tool '" + tool + ".");
    }
}

