/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration.target;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.target.Target;
import org.arquillian.droidium.container.configuration.target.TargetBuilder;
import org.arquillian.droidium.platform.impl.DroidiumPlatformConfiguration;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.jboss.arquillian.core.spi.Validate;

public class TargetParser {
    private AndroidSDK androidSdk;
    private DroidiumPlatformConfiguration platformConfiguration;

    public TargetParser() {
    }

    public TargetParser(AndroidSDK androidSdk, DroidiumPlatformConfiguration platformConfiguration) {
        Validate.notNull((Object)androidSdk, (String)"Android SDK is null!");
        Validate.notNull((Object)platformConfiguration, (String)"Droidium platform configuration is null!");
        this.androidSdk = androidSdk;
        this.platformConfiguration = platformConfiguration;
    }

    public List<Target> parse() {
        HashMap<String, String> androidEnvironment = new HashMap<String, String>();
        androidEnvironment.put("ANDROID_HOME", this.platformConfiguration.getAndroidHome());
        androidEnvironment.put("ANDROID_SDK_HOME", this.platformConfiguration.getAndroidSdkHome());
        List output = ((ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).addEnvironment(androidEnvironment).programName((CharSequence)this.androidSdk.getAndroidPath()).parameters(new CharSequence[]{"list", "target"}).execute().await()).output();
        return this.parseAndroidListTargetOutput(new LinkedList<String>(output));
    }

    public List<Target> parseAndroidListTargetOutput(List<String> outputLines) {
        ArrayList<Target> targets = new ArrayList<Target>();
        if (outputLines.size() < 1) {
            return targets;
        }
        if (outputLines.get(0).contains("Available Android targets:")) {
            outputLines.remove(0);
        }
        ArrayList targetLinesList = new ArrayList();
        ArrayList<String> targetLines = new ArrayList<String>();
        for (String string : outputLines) {
            if (string.contains("----------")) {
                if (targetLines.isEmpty()) continue;
                targetLinesList.add(targetLines);
                targetLines = new ArrayList();
                continue;
            }
            targetLines.add(string.trim());
        }
        if (!targetLines.isEmpty()) {
            targetLinesList.add(targetLines);
        }
        for (List list : targetLinesList) {
            targets.add(TargetBuilder.build(list));
        }
        Collections.sort(targets);
        return targets;
    }
}

