/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.deployment;

import java.io.File;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.deployment.AndroidDeploymentRegister;
import org.arquillian.droidium.container.impl.AndroidApplicationHelper;
import org.arquillian.droidium.container.impl.AndroidApplicationManager;
import org.arquillian.droidium.container.spi.AndroidDeployment;
import org.arquillian.droidium.container.spi.event.AfterAndroidDeploymentDeployed;
import org.arquillian.droidium.container.spi.event.AndroidDeploy;
import org.arquillian.droidium.container.spi.event.BeforeAndroidDeploymentDeployed;
import org.arquillian.droidium.container.tool.APKResignerTool;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.spacelift.execution.Tasks;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.shrinkwrap.api.Archive;

public class AndroidDeploymentInstaller {
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidApplicationHelper> androidApplicationHelper;
    @Inject
    private Instance<AndroidApplicationManager> androidApplicationManager;
    @Inject
    private Instance<AndroidDeploymentRegister> androidDeploymentRegister;
    @Inject
    private Event<BeforeAndroidDeploymentDeployed> beforeDeploy;
    @Inject
    private Event<AfterAndroidDeploymentDeployed> afterDeploy;

    public void onAndroidDeploy(@Observes AndroidDeploy event, DeploymentDescription description) {
        this.beforeDeploy.fire((Object)new BeforeAndroidDeploymentDeployed(event.getArchive()));
        Archive archive = event.getArchive();
        File deployApk = new File(((AndroidSDK)this.androidSDK.get()).getPlatformConfiguration().getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        DroidiumFileUtils.export(archive, deployApk);
        File resignedApk = (File)((APKResignerTool)Tasks.chain((Object)deployApk, APKResignerTool.class)).sdk((AndroidSDK)this.androidSDK.get()).execute().await();
        AndroidDeployment deployment = new AndroidDeployment();
        deployment.setDeployment(archive).setDeployApk(deployApk).setResignedApk(resignedApk).setApplicationBasePackage(((AndroidApplicationHelper)this.androidApplicationHelper.get()).getApplicationBasePackage(resignedApk)).setDeploymentName(description.getName()).setApplicationMainActivity(((AndroidApplicationHelper)this.androidApplicationHelper.get()).getApplicationMainActivity(resignedApk));
        ((AndroidDeploymentRegister)this.androidDeploymentRegister.get()).add(deployment);
        ((AndroidApplicationManager)this.androidApplicationManager.get()).install(deployment);
        this.afterDeploy.fire((Object)new AfterAndroidDeploymentDeployed(deployment));
    }
}

