/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.deployment;

import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceMetadata;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.AndroidApplicationManager;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidDeviceContext {
    @Inject
    @ContainerScoped
    public InstanceProducer<AndroidApplicationManager> androidApplicationManager;
    @Inject
    public Instance<AndroidDevice> androidDevice;
    @Inject
    public Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidDeviceRegister> androidDeviceRegister;

    public void onBeforeDeploy(@Observes BeforeDeploy event, AndroidDevice androidDevice) {
        if (event.getDeployableContainer().getConfigurationClass() != AndroidContainerConfiguration.class) {
            return;
        }
        AndroidDeviceRegister register = (AndroidDeviceRegister)this.androidDeviceRegister.get();
        if (!register.contains(androidDevice)) {
            throw new IllegalStateException("It seems you are trying to deploy deployment to device which is not ready yet. This should never happen.");
        }
        AndroidDeviceMetadata metadata = register.getMetadata(androidDevice);
        metadata.addDeploymentName(event.getDeployment().getName());
        register.put(androidDevice, metadata);
        AndroidApplicationManager androidApplicationManager = new AndroidApplicationManager(androidDevice, (AndroidSDK)this.androidSDK.get());
        this.androidApplicationManager.set((Object)androidApplicationManager);
    }

    public void onBeforeUnDeploy(@Observes BeforeUnDeploy event, AndroidDevice androidDevice) {
        if (event.getDeployableContainer().getConfigurationClass() != AndroidContainerConfiguration.class) {
            return;
        }
        AndroidApplicationManager androidApplicationManager = new AndroidApplicationManager(androidDevice, (AndroidSDK)this.androidSDK.get());
        this.androidApplicationManager.set((Object)androidApplicationManager);
    }

    public void onAndroidDeviceReady(@Observes AndroidDeviceReady event, Container container) {
        if (!((AndroidDeviceRegister)this.androidDeviceRegister.get()).contains(event.getDevice())) {
            AndroidDeviceMetadata metadata = new AndroidDeviceMetadata();
            metadata.setContainerQualifier(container.getName());
            ((AndroidDeviceRegister)this.androidDeviceRegister.get()).put(event.getDevice(), metadata);
        }
    }
}

