/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.HashMap;
import java.util.Map;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceMetadata;
import org.arquillian.droidium.container.api.AndroidDeviceRegister;
import org.arquillian.droidium.container.configuration.Validate;

public class AndroidDeviceRegisterImpl
implements AndroidDeviceRegister {
    private final Map<AndroidDevice, AndroidDeviceMetadata> register = new HashMap<AndroidDevice, AndroidDeviceMetadata>();

    public void put(AndroidDevice androidDevice, AndroidDeviceMetadata androidDeviceMetaData) {
        Validate.notNull(androidDevice, "Android device to put into register can not be a null object!");
        Validate.notNull(androidDeviceMetaData, "Android device meta data to put into register can not be a null object!");
        this.register.put(androidDevice, androidDeviceMetaData);
    }

    public AndroidDeviceMetadata getMetadata(AndroidDevice androidDevice) {
        if (androidDevice != null) {
            return this.register.get(androidDevice);
        }
        return null;
    }

    public boolean contains(AndroidDevice androidDevice) {
        return this.register.containsKey(androidDevice);
    }

    public void remove(AndroidDevice device) {
        this.register.remove(device);
    }

    public void removeByContainerQualifier(String containerQualifier) {
        Map.Entry<AndroidDevice, AndroidDeviceMetadata> toRemove = null;
        for (Map.Entry<AndroidDevice, AndroidDeviceMetadata> entry : this.register.entrySet()) {
            if (!entry.getValue().getContainerQualifier().equals(containerQualifier)) continue;
            toRemove = entry;
            break;
        }
        if (toRemove != null) {
            this.register.remove(toRemove.getKey());
        }
    }

    public void addDeploymentForDevice(AndroidDevice device, String deploymentName) {
        AndroidDeviceMetadata metadata = this.register.get(device);
        if (metadata != null) {
            metadata.getDeploymentNames().add(deploymentName);
        }
        this.register.put(device, metadata);
    }

    public AndroidDevice getByContainerQualifier(String containerQualifier) {
        for (Map.Entry<AndroidDevice, AndroidDeviceMetadata> entry : this.register.entrySet()) {
            if (!entry.getValue().getContainerQualifier().equals(containerQualifier)) continue;
            return entry.getKey();
        }
        return null;
    }

    public AndroidDevice getByDeploymentName(String deploymentName) {
        for (Map.Entry<AndroidDevice, AndroidDeviceMetadata> entry : this.register.entrySet()) {
            if (!entry.getValue().getDeploymentNames().contains(deploymentName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public int size() {
        return this.register.size();
    }

    public AndroidDevice getSingle() {
        if (this.register.size() != 1) {
            throw new IllegalStateException("You can not get single AndroidDevice from register. There is more than 1 of it!");
        }
        return this.register.entrySet().iterator().next().getKey();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<AndroidDevice, AndroidDeviceMetadata> entry : this.register.entrySet()) {
            sb.append(entry.getKey()).append("\n").append("container qualifier: ").append(entry.getValue().getContainerQualifier()).append("\n").append("deployment names: ").append(entry.getValue().getDeploymentNames()).append("\n");
        }
        return sb.toString();
    }
}

