/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceSelector;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierType;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.spi.event.AndroidBridgeInitialized;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceCreate;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidDeviceSelectorImpl
implements AndroidDeviceSelector {
    private static Logger logger = Logger.getLogger(AndroidDeviceSelectorImpl.class.getSimpleName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidDevice> androidDevice;
    @Inject
    private Instance<AndroidBridge> androidBridge;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<IdentifierGenerator<FileType>> idGenerator;
    @Inject
    private Event<AndroidVirtualDeviceAvailable> androidVirtualDeviceAvailable;
    @Inject
    private Event<AndroidVirtualDeviceCreate> androidVirtualDeviceCreate;
    @Inject
    private Event<AndroidDeviceReady> androidDeviceReady;
    @Inject
    private Event<AndroidVirtualDeviceDelete> androidDeviceDelete;

    public void selectDevice(@Observes AndroidBridgeInitialized event) throws AndroidExecutionException {
        AndroidDevice device = null;
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        if (this.isConnectingToPhysicalDevice()) {
            try {
                device = this.getPhysicalDevice();
                device.setAlreadyRuns(true);
                this.setDronePorts(device);
                this.androidDevice.set((Object)device);
                this.androidDeviceReady.fire((Object)new AndroidDeviceReady(device));
                return;
            }
            catch (AndroidExecutionException ex) {
                throw new AndroidExecutionException(String.format("Unable to connect to physical device with serial ID '%s'. ", configuration.getSerialId()), (Throwable)ex);
            }
        }
        if (this.isConnectingToVirtualDevice() && (device = this.getVirtualDevice()) != null) {
            device.setAlreadyRuns(true);
            this.setDronePorts(device);
            this.androidDevice.set((Object)device);
            this.androidDeviceReady.fire((Object)new AndroidDeviceReady(device));
            return;
        }
        List<AndroidDevice> devices = this.getDevices();
        if (configuration.getAvdName() == null && configuration.getSerialId() == null) {
            if (devices.size() == 1) {
                device = devices.get(0);
                device.setAlreadyRuns(true);
                this.setDronePorts(device);
                this.androidDevice.set((Object)device);
                this.androidDeviceReady.fire((Object)new AndroidDeviceReady(device));
                return;
            }
            if (devices.size() > 1) {
                throw new IllegalStateException("The selection of Android device is ambiguous. There are multiple devices and it is not able to recognize which one to choose.");
            }
        }
        if (configuration.getAvdName() == null) {
            String generatedAvdName = ((IdentifierGenerator)this.idGenerator.get()).getIdentifier((IdentifierType)FileType.AVD);
            configuration.setAvdName(generatedAvdName);
            configuration.setAvdGenerated(true);
        }
        List<String> androidListAVDOutput = this.getAndroidListAVDOutput(false);
        List<String> compactAndroidListAVDOutput = this.getAndroidListAVDOutput(true);
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            for (String line : androidListAVDOutput) {
                sb.append(line).append("\n");
            }
            System.out.print(sb.toString());
        }
        if (this.isInCompactAVDList(compactAndroidListAVDOutput, configuration.getAvdName())) {
            this.androidVirtualDeviceAvailable.fire((Object)new AndroidVirtualDeviceAvailable(configuration.getAvdName()));
        } else if (this.isInRawAVDList(androidListAVDOutput, configuration.getAvdName())) {
            logger.log(Level.INFO, "You want to start an emulator backed by AVD of name {0} which seems to be broken. This AVD will be deleted and AVD of the same name with configuration from arquillian.xml will be created and started afterwards.", new Object[]{configuration.getAvdName()});
            this.androidDeviceDelete.fire((Object)new AndroidVirtualDeviceDelete());
            this.androidVirtualDeviceCreate.fire((Object)new AndroidVirtualDeviceCreate());
        } else {
            this.androidVirtualDeviceCreate.fire((Object)new AndroidVirtualDeviceCreate());
        }
    }

    private boolean isInCompactAVDList(List<String> lines, String avdName) {
        for (String temp : lines) {
            if (!temp.contains(avdName)) continue;
            return true;
        }
        return false;
    }

    private boolean isInRawAVDList(List<String> lines, String avdName) {
        for (String temp : lines) {
            if (!temp.contains("Name:") || !temp.substring(temp.indexOf(" ")).contains(avdName)) continue;
            return true;
        }
        return false;
    }

    private void setDronePorts(AndroidDevice device) {
        device.setDroneHostPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneHostPort());
        device.setDroneGuestPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneGuestPort());
    }

    private boolean isConnectingToVirtualDevice() {
        return this.isConsolePortDefined() || this.isAvdNameDefined();
    }

    private boolean isConnectingToPhysicalDevice() {
        String serialId = ((AndroidContainerConfiguration)this.configuration.get()).getSerialId();
        return serialId != null && !serialId.trim().isEmpty();
    }

    private boolean isConsolePortDefined() {
        String consolePort = ((AndroidContainerConfiguration)this.configuration.get()).getConsolePort();
        return consolePort != null && !consolePort.trim().equals("");
    }

    private boolean isAvdNameDefined() {
        String avdName = ((AndroidContainerConfiguration)this.configuration.get()).getAvdName();
        return avdName != null && !avdName.trim().equals("");
    }

    private boolean isOnlyConsolePortAvailable() {
        return this.isConsolePortDefined() && !this.isAvdNameDefined();
    }

    private boolean isOnlyAvdNameAvailable() {
        return this.isAvdNameDefined() && !this.isConsolePortDefined();
    }

    private List<AndroidDevice> getDevices() {
        return ((AndroidBridge)this.androidBridge.get()).getDevices();
    }

    private AndroidDevice getVirtualDevice() {
        String consolePort = ((AndroidContainerConfiguration)this.configuration.get()).getConsolePort();
        String avdName = ((AndroidContainerConfiguration)this.configuration.get()).getAvdName();
        if (this.isOnlyConsolePortAvailable()) {
            try {
                return this.getVirtualDeviceByConsolePort(consolePort);
            }
            catch (AndroidExecutionException ex) {
                return null;
            }
        }
        if (this.isOnlyAvdNameAvailable()) {
            try {
                return this.getVirtualDeviceByAvdName(avdName);
            }
            catch (AndroidExecutionException ex) {
                return null;
            }
        }
        try {
            return this.getVirtualDevice(consolePort, avdName);
        }
        catch (AndroidExecutionException ex) {
            return null;
        }
    }

    private AndroidDevice getVirtualDevice(String consolePort, String avdName) throws AndroidExecutionException {
        Validate.notNullOrEmpty(consolePort, "Console port to get emulator of is a null object or an empty string.");
        Validate.notNullOrEmpty(avdName, "AVD name to get emulator of is a null object or an empty string.");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            try {
                if (!device.getConsolePort().equals(consolePort) || !device.getAvdName().equals(avdName)) continue;
                logger.log(Level.INFO, "Connecting to virtual device running on console port {0} with AVD name {1}.", new Object[]{consolePort, avdName});
                return device;
            }
            catch (NullPointerException ex) {
                logger.severe("Unable to connect to the emulator. Please be sure you are running adb server.");
            }
        }
        return null;
    }

    private AndroidDevice getVirtualDeviceByConsolePort(String consolePort) throws AndroidExecutionException {
        Validate.notNullOrEmpty(consolePort, "Console port to get emulator of is a null object or an empty string.");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            String deviceConsolePort = device.getConsolePort();
            if (deviceConsolePort == null || !deviceConsolePort.equals(consolePort)) continue;
            logger.log(Level.INFO, "Connecting to virtual device running on console port {0}.", consolePort);
            return device;
        }
        throw new AndroidExecutionException("Unable to get Android emulator running on the console port " + consolePort);
    }

    private AndroidDevice getVirtualDeviceByAvdName(String avdName) throws AndroidExecutionException {
        Validate.notNullOrEmpty(avdName, "AVD name to get emulator of is a null object or an empty string");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            String deviceAvdName = device.getAvdName();
            if (deviceAvdName == null || !deviceAvdName.equals(avdName)) continue;
            logger.log(Level.INFO, "Connecting to virtual device running on AVD of name {0}.", avdName);
            return device;
        }
        throw new AndroidExecutionException("No running emulator of AVD name " + avdName + ".");
    }

    private AndroidDevice getPhysicalDevice() throws AndroidExecutionException {
        String serialId = ((AndroidContainerConfiguration)this.configuration.get()).getSerialId();
        List devices = ((AndroidBridge)this.androidBridge.get()).getDevices();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no physical devices on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            if (device.isEmulator() || !serialId.equals(device.getSerialNumber())) continue;
            logger.log(Level.INFO, "Connecting to physical device with serial ID {0}", serialId);
            return device;
        }
        throw new AndroidExecutionException("Unable to get device with serial ID " + serialId + ".");
    }

    private List<String> getAndroidListAVDOutput(boolean compact) {
        try {
            CommandBuilder cb = new CommandBuilder((CharSequence)((AndroidSDK)this.androidSDK.get()).getAndroidPath()).parameter((CharSequence)"list").parameter((CharSequence)"avd");
            if (compact) {
                cb.parameter((CharSequence)"-c");
            }
            Command command = cb.build();
            return ((ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).command(command).execute().await()).output();
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException((Throwable)ex, "Unable to get list of AVDs", new Object[0]);
        }
    }
}

