/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceCreate;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDeleted;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessInteraction;
import org.arquillian.spacelift.process.ProcessInteractionBuilder;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidVirtualDeviceManager {
    private static final Logger logger = Logger.getLogger(AndroidVirtualDeviceManager.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Event<AndroidVirtualDeviceAvailable> androidVirtualDeviceAvailable;
    @Inject
    private Event<AndroidVirtualDeviceDeleted> androidVirtualDeviceDeleted;
    @Inject
    private Event<AndroidSDCardDelete> androidSDCardDelete;
    @Inject
    private Event<AndroidSDCardCreate> androidSDCardCreate;

    public void deleteAndroidVirtualDevice(@Observes AndroidVirtualDeviceDelete event) {
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        String avdName = configuration.getAvdName();
        try {
            Command deleteAvdCommand = new CommandBuilder((CharSequence)sdk.getAndroidPath()).parameter((CharSequence)"delete").parameter((CharSequence)"avd").parameter((CharSequence)"-n").parameter((CharSequence)avdName).build();
            ((CommandTool)Tasks.prepare(CommandTool.class)).command(deleteAvdCommand).execute().await();
            logger.log(Level.INFO, "Android Virtual Device {0} deleted.", avdName);
        }
        catch (AndroidExecutionException ex) {
            throw new AndroidExecutionException("Unable to delete Android Virtual device " + avdName, (Throwable)ex);
        }
        this.androidSDCardDelete.fire((Object)new AndroidSDCardDelete());
        this.androidVirtualDeviceDeleted.fire((Object)new AndroidVirtualDeviceDeleted(configuration.getAvdName()));
    }

    public void createAndroidVirtualDevice(@Observes AndroidVirtualDeviceCreate event) throws AndroidExecutionException {
        Validate.notNulls(new Object[]{this.configuration.get(), this.androidSDK.get()}, "container configuration injection or Android SDK injection is null");
        this.androidSDCardCreate.fire((Object)new AndroidSDCardCreate());
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        try {
            CommandBuilder cb = new CommandBuilder((CharSequence)sdk.getAndroidPath()).parameter((CharSequence)"create").parameter((CharSequence)"avd").parameter((CharSequence)"-n").parameter((CharSequence)configuration.getAvdName()).parameter((CharSequence)"-t").parameter((CharSequence)configuration.getTarget()).parameter((CharSequence)"-f");
            if (configuration.getAbi() != null && !"".equals(configuration.getAbi())) {
                cb.parameter((CharSequence)"-b").parameter((CharSequence)configuration.getAbi());
            }
            if (configuration.getSdCard() != null && new File(configuration.getSdCard()).exists()) {
                cb.parameter((CharSequence)"-c").parameter((CharSequence)configuration.getSdCard());
            } else {
                cb.parameter((CharSequence)"-c").parameter((CharSequence)configuration.getSdSize());
            }
            logger.log(Level.INFO, "Creating new avd using: {0}", cb);
            ProcessInteraction interaction = new ProcessInteractionBuilder().when("Do you wish to create a custom hardware profile \\[no\\]").replyWith("no" + System.getProperty("line.separator")).build();
            ((CommandTool)Tasks.prepare(CommandTool.class)).command(cb).interaction(interaction).execute().await();
            configuration.setAvdGenerated(true);
            this.androidVirtualDeviceAvailable.fire((Object)new AndroidVirtualDeviceAvailable(configuration.getAvdName()));
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException((Throwable)ex, "Unable to create a new AVD Device", new Object[0]);
        }
    }
}

