/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.impl.AndroidDeviceImpl;

public class DeviceDiscovery
implements AndroidDebugBridge.IDeviceChangeListener {
    private static final Logger logger = Logger.getLogger(DeviceDiscovery.class.getName());
    private IDevice delegate;
    private AndroidDevice device;
    private boolean online;
    private boolean offline;

    public void deviceChanged(IDevice delegate, int changeMask) {
        if (this.delegate.equals(delegate) && (changeMask & 1) == 1 && this.device.isOnline()) {
            this.online = true;
        }
    }

    public void deviceConnected(IDevice delegate) {
        this.delegate = delegate;
        this.device = new AndroidDeviceImpl(delegate);
        logger.log(Level.INFO, "Discovered an emulator device id={0} connected to ADB bus", this.device.getSerialNumber());
    }

    public void deviceDisconnected(IDevice delegate) {
        if (delegate.isEmulator()) {
            if (delegate.getAvdName().equals(this.device.getAvdName())) {
                this.offline = true;
                logger.fine("Device id=" + delegate.getAvdName() + " disconnected from ADB bus.");
            }
        } else if (delegate.getSerialNumber().equals(this.device.getSerialNumber())) {
            this.offline = true;
            logger.fine("Device id=" + delegate.getSerialNumber() + " disconnected from ADB bus.");
        }
    }

    public DeviceDiscovery setDevice(AndroidDevice device) {
        this.device = device;
        return this;
    }

    public AndroidDevice getDevice() {
        return this.device;
    }

    public DeviceDiscovery setDelegate(IDevice delegate) {
        this.delegate = delegate;
        return this;
    }

    public IDevice getDelegate() {
        return this.delegate;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isOffline() {
        return this.offline;
    }
}

