/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.log.LogcatHelper;
import org.arquillian.droidium.container.spi.event.AndroidBridgeTerminated;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Task;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidLogInitializer {
    private static final Logger logger = Logger.getLogger(AndroidLogInitializer.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<LogcatHelper> logcatHelper;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    private Execution<Writer> logcatExecution;

    public void initAndroidLog(@Observes AndroidDeviceReady event) {
        logger.info("Initializing Android LogcatReader");
        if (this.logcatHelper.get() == null) {
            this.logcatHelper.set((Object)new LogcatHelper((AndroidContainerConfiguration)this.configuration.get(), (AndroidDevice)this.androidDevice.get()));
        }
        this.logcatExecution = ((LogcatReader)Tasks.prepare(LogcatReader.class)).androidSdk((AndroidSDK)this.androidSDK.get()).containerConfiguration((AndroidContainerConfiguration)this.configuration.get()).androidDevice((AndroidDevice)this.androidDevice.get()).writer(((LogcatHelper)this.logcatHelper.get()).prepareWriter()).execute();
    }

    public void terminateAndroidLog(@Observes AndroidBridgeTerminated event) {
        this.logcatExecution.terminate();
        Writer w = (Writer)this.logcatExecution.await();
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class LogcatReader
    extends Task<Object, Writer> {
        private AndroidContainerConfiguration configuration;
        private AndroidSDK androidSDK;
        private AndroidDevice androidDevice;
        private Writer writer;
        private Pattern pattern;
        private List<String> whiteList = new ArrayList<String>();
        private List<String> blackList = new ArrayList<String>();
        private Map<Integer, String> processMap = new HashMap<Integer, String>();

        private LogcatReader() {
        }

        public LogcatReader androidDevice(AndroidDevice device) {
            this.androidDevice = device;
            return this;
        }

        public LogcatReader androidSdk(AndroidSDK sdk) {
            this.androidSDK = sdk;
            return this;
        }

        public LogcatReader containerConfiguration(AndroidContainerConfiguration configuration) {
            this.configuration = configuration;
            if (configuration.getLogPackageWhitelist() != null) {
                String[] whiteList;
                for (String packageName : whiteList = configuration.getLogPackageWhitelist().split(",")) {
                    this.whiteList.add(this.escapePackageName(packageName));
                }
            }
            if (configuration.getLogPackageBlacklist() != null) {
                String[] blackList;
                for (String packageName : blackList = configuration.getLogPackageBlacklist().split(",")) {
                    this.blackList.add(this.escapePackageName(packageName));
                }
            }
            return this;
        }

        public LogcatReader writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        protected Writer process(Object input) throws Exception {
            if (this.writer == null) {
                return null;
            }
            try {
                Command command = new CommandBuilder((CharSequence)this.androidSDK.getAdbPath()).parameter((CharSequence)"-s").parameter((CharSequence)this.androidDevice.getSerialNumber()).parameter((CharSequence)"logcat").parameter((CharSequence)"-c").build();
                ProcessBuilder builder = new ProcessBuilder(command.getFullCommand());
                Process process = builder.start();
                command = new CommandBuilder((CharSequence)this.androidSDK.getAdbPath()).parameter((CharSequence)"-s").parameter((CharSequence)this.androidDevice.getSerialNumber()).parameter((CharSequence)"logcat").parameter((CharSequence)("*:" + this.configuration.getLogLevel())).build();
                builder = new ProcessBuilder(command.getFullCommand());
                process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!this.shouldWrite(line)) continue;
                    this.writer.write(line);
                    this.writer.flush();
                }
                this.writer.close();
                reader.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error with logcat logging!", e);
            }
            return this.writer;
        }

        private String escapePackageName(String packageName) {
            return packageName.replace("\\", "\\\\").replace(".", "\\.").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("?", "\\?").replace("+", "\\+").replace("*", ".*?");
        }

        private boolean shouldWrite(String line) {
            String processName;
            Matcher matcher;
            if (!this.configuration.isLogFilteringEnabled()) {
                return true;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile("./.+?\\(([\\s0-9]+?)\\):.*");
            }
            if (!(matcher = this.pattern.matcher(line)).matches()) {
                return false;
            }
            String processIdString = matcher.group(1).trim();
            Integer processId = Integer.valueOf(processIdString);
            if (!this.processMap.containsKey(processId)) {
                this.loadProcessMap();
            }
            if ((processName = this.processMap.get(processId)) == null) {
                processName = "";
            }
            for (String regex : this.whiteList) {
                if (!processName.matches(regex)) continue;
                return true;
            }
            for (String regex : this.blackList) {
                if (!processName.matches(regex)) continue;
                return false;
            }
            return true;
        }

        private void loadProcessMap() {
            try {
                this.processMap.clear();
                Command command = new CommandBuilder((CharSequence)this.androidSDK.getAdbPath()).parameter((CharSequence)"-s").parameter((CharSequence)this.androidDevice.getSerialNumber()).parameter((CharSequence)"shell").parameter((CharSequence)"ps").build();
                List runningProcesses = ((ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).command(command).execute().await()).output();
                Pattern pattern = Pattern.compile(".*?\\s+([0-9]+)\\s+[0-9]+\\s+[0-9]+\\s+[0-9]+\\s+[0-9a-f]+\\s+[0-9a-f]+\\s.?\\s(.*)");
                for (String line : runningProcesses) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    Integer processId = Integer.valueOf(matcher.group(1));
                    String processName = matcher.group(2);
                    this.processMap.put(processId, processName);
                }
            }
            catch (ExecutionException e) {
                logger.log(Level.SEVERE, "Couldn't load process map!", e);
            }
        }
    }
}

