/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.task;

import java.io.File;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.task.CreateKeyStoreTask;
import org.arquillian.spacelift.execution.Task;
import org.arquillian.spacelift.execution.Tasks;

public class CheckKeyStoreTask
extends Task<Object, Void> {
    private AndroidSDK androidSDK;

    public CheckKeyStoreTask sdk(AndroidSDK androidSDK) {
        this.androidSDK = androidSDK;
        return this;
    }

    protected Void process(Object input) throws Exception {
        if (this.androidSDK == null) {
            throw new IllegalStateException("You have to set androidSdk via setter.");
        }
        if (!Validate.isReadable(new File(this.androidSDK.getPlatformConfiguration().getKeystore()))) {
            File defaultKeyStore = new File(this.getDefaultKeyStorePath());
            if (!Validate.isReadable(defaultKeyStore)) {
                ((CreateKeyStoreTask)Tasks.prepare(CreateKeyStoreTask.class)).keyStoreToCreate(defaultKeyStore).sdk(this.androidSDK).execute().await();
            } else {
                this.androidSDK.getPlatformConfiguration().setProperty("keystore", defaultKeyStore.getAbsolutePath());
            }
        }
        return null;
    }

    private String getDefaultKeyStorePath() {
        String separator = System.getProperty("file.separator");
        return this.androidSDK.getPlatformConfiguration().getAndroidSdkHome() + ".android" + separator + "debug.keystore";
    }
}

