/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.task;

import com.android.ddmlib.AndroidDebugBridge;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.impl.DeviceDiscovery;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Task;

public class EmulatorShutdownTask
extends Task<AndroidDevice, Boolean> {
    private CountDownWatch countdown = new CountDownWatch(60L, TimeUnit.SECONDS);

    public Task<AndroidDevice, Boolean> countdown(CountDownWatch countdown) {
        this.countdown = countdown;
        return this;
    }

    protected Boolean process(AndroidDevice device) throws Exception {
        final DeviceDiscovery deviceDiscovery = new DeviceDiscovery();
        deviceDiscovery.setDevice(device);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        try {
            this.getExecutionService().execute(this.sendEmulatorCommand(this.extractPortFromDevice(device), "kill")).awaitAtMost(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException(String.format("Sending of kill command to emulator {0} was not completed successfully in 10 seconds.", device.getSerialNumber()), (Throwable)ex);
        }
        boolean shuttedDown = false;
        try {
            shuttedDown = (Boolean)this.getExecutionService().execute((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return deviceDiscovery.isOffline();
                }
            }).reexecuteEvery(1L, TimeUnit.SECONDS).until(this.countdown, (ExecutionCondition)new ExecutionCondition<Boolean>(){

                public boolean satisfiedBy(Boolean offline) throws ExecutionException {
                    return offline;
                }
            });
        }
        catch (ExecutionException ex) {
            throw new AndroidExecutionException(String.format("Unable to get the emulator {0} down", device.getSerialNumber()), (Throwable)ex);
        }
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceDiscovery);
        return shuttedDown;
    }

    private int extractPortFromDevice(AndroidDevice device) {
        String portStr = device.getSerialNumber().substring(device.getSerialNumber().lastIndexOf("-") + 1);
        if (portStr != null && portStr.length() > 0) {
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    private Callable<Boolean> sendEmulatorCommand(final int port, final String command) {
        return new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws IOException {
                Socket socket = null;
                BufferedReader in = null;
                PrintWriter out = null;
                try {
                    socket = new Socket("127.0.0.1", port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String telnetOutputString = null;
                    while ((telnetOutputString = in.readLine()) != null && !telnetOutputString.equals("OK")) {
                    }
                    out.write(command);
                    out.write("\n");
                    out.flush();
                }
                finally {
                    try {
                        out.close();
                        in.close();
                        socket.close();
                    }
                    catch (Exception e) {}
                }
                return true;
            }
        };
    }
}

