/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.task;

import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Task;
import org.arquillian.spacelift.process.ProcessResult;

public class EmulatorStatusCheckTask
extends Task<Object, Void> {
    public static final ExecutionCondition<ProcessResult> isBootedCondition = new EmulatorIsBootedExecutionCondition();
    private Execution<ProcessResult> emulatorExecution;

    public Task<Object, Void> execution(Execution<ProcessResult> emulatorExecution) {
        this.emulatorExecution = emulatorExecution;
        return this;
    }

    protected Void process(Object input) throws Exception {
        if (this.emulatorExecution.isFinished() && this.emulatorExecution.hasFailed()) {
            ProcessResult processDetails = (ProcessResult)this.emulatorExecution.await();
            if (processDetails != null) {
                StringBuilder sb = new StringBuilder();
                for (String line : processDetails.output()) {
                    sb.append(line).append("\n");
                }
                throw new AndroidExecutionException(String.format("Starting of emulator failed with exit value {0} and output {1}", processDetails.exitValue(), sb.toString()));
            }
            throw new IllegalStateException("Execution of emulator process failed.");
        }
        return null;
    }

    private static class EmulatorIsBootedExecutionCondition
    implements ExecutionCondition<ProcessResult> {
        private EmulatorIsBootedExecutionCondition() {
        }

        public boolean satisfiedBy(ProcessResult processResult) throws ExecutionException {
            for (String line : processResult.output()) {
                if (!line.contains("[ro.runtime.firstboot]")) continue;
                return true;
            }
            return false;
        }
    }
}

