/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.tool;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.task.CheckKeyStoreTask;
import org.arquillian.droidium.container.utils.DroidiumFileUtils;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.arquillian.spacelift.tool.Tool;

public class APKSignerTool
extends Tool<File, File> {
    protected AndroidSDK androidSDK;

    public APKSignerTool sdk(AndroidSDK androidSDK) {
        this.androidSDK = androidSDK;
        return this;
    }

    protected Collection<String> aliases() {
        return Arrays.asList("apk_signer");
    }

    protected File process(File toSign) throws Exception {
        if (toSign == null || !toSign.exists()) {
            throw new IllegalStateException("File to be signed is either null or it does not exists");
        }
        ((CheckKeyStoreTask)Tasks.prepare(CheckKeyStoreTask.class)).sdk(this.androidSDK).execute().await();
        File signed = new File(this.androidSDK.getPlatformConfiguration().getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        Command jarSignerCommand = new CommandBuilder((CharSequence)this.androidSDK.getPathForJavaTool("jarsigner")).parameter((CharSequence)"-sigalg").parameter((CharSequence)"MD5withRSA").parameter((CharSequence)"-digestalg").parameter((CharSequence)"SHA1").parameter((CharSequence)"-signedjar").parameter((CharSequence)signed.getAbsolutePath()).parameter((CharSequence)"-storepass").parameter((CharSequence)this.androidSDK.getPlatformConfiguration().getStorepass()).parameter((CharSequence)"-keystore").parameter((CharSequence)new File(this.androidSDK.getPlatformConfiguration().getKeystore()).getAbsolutePath()).parameter((CharSequence)toSign.getAbsolutePath()).parameter((CharSequence)this.androidSDK.getPlatformConfiguration().getAlias()).build();
        ((CommandTool)Tasks.prepare(CommandTool.class)).command(jarSignerCommand).execute().await();
        return signed;
    }
}

