/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.tool;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.arquillian.spacelift.tool.Tool;

public class AndroidKillTool
extends Tool<Integer, ProcessResult> {
    private static final Logger logger = Logger.getLogger(AndroidKillTool.class.getName());
    private AndroidSDK androidSdk;
    private int signum = 9;

    public AndroidKillTool androidSdk(AndroidSDK androidSdk) {
        Validate.notNull(androidSdk, "Android Sdk is null object.");
        this.androidSdk = androidSdk;
        return this;
    }

    public AndroidKillTool signum(int signum) {
        if (signum > 0) {
            this.signum = signum;
        } else {
            logger.log(Level.INFO, String.format("Given signal number '%s' is lower then 0 and will be ignored.", signum));
        }
        return this;
    }

    public AndroidKillTool signum(String signum) {
        Validate.notNullOrEmpty(signum, "Signal number is a null object or an empty string!");
        try {
            this.signum(Integer.parseInt(signum));
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, String.format("Unable to convert given signal number '%s' into a number.", signum));
        }
        return this;
    }

    protected Collection<String> aliases() {
        return Arrays.asList("android_kill");
    }

    protected ProcessResult process(Integer pid) throws Exception {
        Validate.notNull(pid, "PID for process to kill is a null object!");
        Validate.notNull(this.androidSdk, "Android SDK is a null object!");
        if (pid <= 0) {
            throw new IllegalStateException("PID to kill is lower then 0.");
        }
        ProcessResult processResult = (ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).programName((CharSequence)this.androidSdk.getAdbPath()).addEnvironment(this.androidSdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).parameters(new CharSequence[]{"shell", "kill", "-" + this.signum, pid.toString()}).execute().await();
        return processResult;
    }
}

