/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.tool;

import java.util.Arrays;
import java.util.Collection;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.arquillian.spacelift.tool.Tool;

public class AndroidPidTool
extends Tool<String, Integer> {
    private AndroidSDK androidSdk;

    public AndroidPidTool androidSdk(AndroidSDK androidSdk) {
        Validate.notNull(androidSdk, "Android SDK is null object.");
        this.androidSdk = androidSdk;
        return this;
    }

    protected Collection<String> aliases() {
        return Arrays.asList("android_pid");
    }

    protected Integer process(String androidProcessName) throws Exception {
        Validate.notNullOrEmpty(androidProcessName, "Android process name to get PID of is a null object or an empty string.");
        Validate.notNull(this.androidSdk, "Android SDK is a null object!");
        ProcessResult psResult = (ProcessResult)((CommandTool)Tasks.prepare(CommandTool.class)).programName((CharSequence)this.androidSdk.getAdbPath()).addEnvironment(this.androidSdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).parameter((CharSequence)"shell").parameter((CharSequence)"ps").execute().await();
        int pid = -1;
        for (String psLine : psResult.output()) {
            if (psLine == null || !psLine.trim().endsWith(androidProcessName)) continue;
            pid = this.parsePid(psLine.trim(), androidProcessName);
            break;
        }
        return pid;
    }

    private int parsePid(String outputLine, String androidProcessName) {
        String[] splitting = outputLine.split(" +");
        if (splitting.length < 2) {
            throw new IllegalStateException(String.format("Unable to get PID from output line of Android 'ps' command for '%s' process.", androidProcessName));
        }
        try {
            return Integer.parseInt(splitting[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(String.format("Unable to get PID from output line of Android 'ps' command for '%s' process.", androidProcessName));
        }
    }
}

