/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.tool;

import java.io.File;
import org.arquillian.droidium.container.api.ScreenrecordOptions;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.impl.CommandTool;

public class ScreenRecordToolBuilder {
    private AndroidSDK androidSdk;
    private ScreenrecordOptions options;
    private String remoteFilePath;

    public ScreenRecordToolBuilder androidSdk(AndroidSDK androidSdk) {
        this.androidSdk = androidSdk;
        return this;
    }

    public ScreenRecordToolBuilder options(ScreenrecordOptions options) {
        this.options = options;
        return this;
    }

    public ScreenRecordToolBuilder remoteFilePath(String remoteFilePath) {
        this.remoteFilePath = remoteFilePath;
        return this;
    }

    public ScreenRecordToolBuilder remoteFile(File remoteFile) {
        return this.remoteFilePath(remoteFile.getAbsolutePath());
    }

    public CommandTool build() {
        Validate.notNull(this.androidSdk, "You have not set AndroidSDK.");
        Validate.notNull(this.options, "You have not set options.");
        Validate.notNullOrEmpty(this.remoteFilePath, "You have not set remote file path or it is empty string.");
        CommandTool screenRecorderTool = ((CommandTool)Tasks.prepare(CommandTool.class)).programName((CharSequence)this.androidSdk.getAdbPath()).addEnvironment(this.androidSdk.getPlatformConfiguration().getAndroidSystemEnvironmentProperties()).parameter((CharSequence)"shell").parameter((CharSequence)"screenrecord");
        if (this.options.width > 0 && this.options.height > 0) {
            screenRecorderTool.parameters(new CharSequence[]{"--size", this.options.width + "x" + this.options.height});
        }
        if (this.options.bitrate > 0L) {
            screenRecorderTool.parameters(new CharSequence[]{"--bit-rate", Long.toString(this.options.bitrate)});
        }
        screenRecorderTool.parameters(new CharSequence[]{"--time-limit", "180"});
        screenRecorderTool.parameter((CharSequence)this.remoteFilePath);
        return screenRecorderTool;
    }
}

