/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Validate;

public class Monkey
implements AndroidDeviceOutputReciever {
    private static final Logger logger = Logger.getLogger(Monkey.class.getName());
    private final Writer output;
    private boolean active = false;
    private boolean contains = false;
    private final String waitForString;

    public Monkey(File output, String waitForString, boolean contains) throws IOException {
        Validate.notNull(output, "File to write logs for Monkey can't be null!");
        Validate.notNullOrEmpty(waitForString, "String to wait for in Monkey can't be null nor empty!");
        this.output = new FileWriter(output);
        this.waitForString = waitForString;
        this.contains = contains;
    }

    public void processNewLines(String[] lines) {
        for (String line : lines) {
            logger.finest(line);
            try {
                this.output.append(line).append("\n").flush();
                if (this.contains) {
                    if (!line.contains(this.waitForString)) continue;
                    this.active = true;
                    return;
                }
                if (line.contains(this.waitForString)) continue;
                this.active = true;
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public static void wait(AndroidDevice device, Monkey monkey, String command) {
        int retries = 5;
        for (int i = 0; i < 5; ++i) {
            device.executeShellCommand(command, (AndroidDeviceOutputReciever)monkey);
            if (monkey.isActive()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        throw new AndroidExecutionException(String.format("Waiting for monkey executing command \"%s\" timeouted in %d seconds.", command, 5));
    }
}

